/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe;

import java.io.File;
import java.io.PrintStream;
import java.util.TreeMap;
import org.rhwlab.LMS.RNASeq.TpmFeatureGroup;

/**
 *
 * @author gevirl
 */
public class FACSDataSet extends DataSet {
    
    static public String[] attributeKeys = {"Series","Rep","Time"};
    
    public FACSDataSet(double minTPM)throws Exception {
        this(FACSSamples.getAllSamples(),TpmFeatureGroup.mRNAno,minTPM);
    }
    public FACSDataSet(String[] expIDs, TpmFeatureGroup group,double minTPM) throws Exception {
        super("GeneTPM",new ExpressionDataFrame(expIDs, group),dataColumns(),attributeKeys);
        
        // set the data columns and the data column attributes
        int n = df.getHeaders().size();  //original size of the dataframe
        
        TreeMap<String,Integer> repCounts = new TreeMap<>();
        String[] samples = FACSSamples.getAllSamples();
        for (int i=0 ; i<samples.length ; ++i){
            String sample = samples[i];
            String tissue = FACSSamples.tissueName(sample);
            String time = FACSSamples.timeString(sample);
            String key = tissue+time;
            Integer count = repCounts.get(key);
            if (count == null){
                count = 1;
            } else {
                ++count;
            }
            repCounts.put(key,count);
            this.setAttribute("Series",i, tissue);
            this.setAttribute("Rep",i, count.toString());
            this.setAttribute("Time",i, time);
        }        
        // filter the rows for low expressing genes
        df.removeRowsByMax(samples[0], samples[samples.length-1],minTPM);        
    }

    static int[] dataColumns(){
        int[] ret = new int[FACSSamples.getAllSamples().length];
        for (int i=0 ; i<ret.length ; ++i){
            ret[i] = i+3;
        }
        return ret;
    }
   
    // initial construction of the FACS dataset
    static public void main(String[] args)throws Exception{
        // form the dataframe from the database
 //      FACSDataSet facsSet = new FACSDataSet(15.0); 
        FACSDataSet facsSet = new FACSDataSet(0.0); 
        
        int iausdhfiuhds=0;
/*
        // add columns for averaging the replicates
        TreeMap<String,List<Integer>> colMap = new TreeMap<>();
        for (String sample : allSamples){
            String tissue = tissueName(sample);
            String time = timeString(sample);
            String key = tissue+time;
            List<Integer> cols = colMap.get(key);
            if (cols == null){
                cols = new ArrayList<>();
                colMap.put(key,cols);
            }
            cols.add(frame.column(sample));
        }
        
        for (String key : colMap.keySet()){
            List<Integer> cols = colMap.get(key);
            int[] columns = new int[cols.size()];
            for (int i=0 ; i<columns.length ; ++i){
                columns[i] = cols.get(i);
            }
            double[][] x = frame.getAsDouble(columns);
            double[] avg = new double[x.length];
            for (int r=0 ; r<avg.length ; ++r){
                avg[r] = 0.0;
                for (int c=0 ; c<x[r].length ; ++c){
                    avg[r] = avg[r] + x[r][c];
                }
                avg[r] = avg[r]/x[r].length;
            }
            frame.addColumn(avg, key);
        }
        
        int asudfhusd=0;
        
        // compute pca columns
        
        double[][] X = frame.getAsDouble(3,n-1);
        Array2DRowRealMatrix mat = new Array2DRowRealMatrix(X);
        PCA pca = new PCA(mat);
        RealMatrix xformed = pca.getTransformedDataMatrix();

        frame.addColumn(xformed.getColumn(0), "PCA1");
        frame.addColumn(xformed.getColumn(1), "PCA2");
        
        // compute t-sne columns
        String[] headers = new String[2];
        headers[0] = "TsneX";
        headers[1] = "TsneY";
        Tsne tsne = new Tsne(frame,frame.column(allSamples[0]),frame.column(allSamples[allSamples.length-1]),headers);
        tsne.run();
        
        String[] avgHeaders = new String[2];
        avgHeaders[0] = "AvgTsneX";
        avgHeaders[1] = "AvgTsneY";
        tsne = new Tsne(frame,frame.column(colMap.firstKey()),frame.column(colMap.lastKey()),avgHeaders);
        tsne.run();
*/        
        facsSet.getDataFrame().save(new PrintStream(new File("/nfs/waterston/FACS.mRNA.filtered.genes.pca.tsne.csv")));        
    }
}
