/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.bomb;

import java.sql.ResultSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.DateCell;
import org.rhwlab.LMS.TextCell;
import org.rhwlab.LMS.models.BRCStockLocation;
import org.rhwlab.LMS.models.BombModel;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */
public class PrepLocation extends TextCell{
    
    @Override
    public void stateChanged(ChangeEvent ce) {
        Object source = ce.getSource();
        if (source instanceof DateCell){
            if (this.getValueAsString().equals("")){
                try {
                    this.setValue(nextLocation());
                } catch (Exception ex) {
                    Logger.getLogger(PrepLocation.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }
    
    public boolean validate(String newValue){
        BRCStockLocation loc = new BRCStockLocation();
        
        return loc.parse(newValue);
    }
    
    // find the next availalble prep location
    public String nextLocation() throws Exception{
        BRCStockLocation retBRC = ((BombModel)model).maxPrepLocation();
        
        // find the maximum for the database
        String sql = "Select PrepLocation from Bomb where PrepLocation is not null and PrepLocation != \'\'";
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            String prepLoc = rs.getString("PrepLocation");
            BRCStockLocation prepBRC = new BRCStockLocation(prepLoc);
            if (prepBRC.compareTo(retBRC)>0){
                retBRC = prepBRC;
            }
        }
        
        // look for the maximum in the spreadsheet
        retBRC.increment(9, 9);
        return retBRC.asString();
    }
}
