/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.bomb;

import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.IntegerCell;
import org.rhwlab.LMS.models.BombModel;
import org.rhwlab.spreadsheet.CellBase;

/**
 *
 * @author gevirl
 */
public class BombNumber extends IntegerCell {
    public BombNumber(){
        this("");
    }
    public BombNumber(String id){
        super(id);
        inputs.put("DNAPrepID",null);
    }
    @Override
    public void stateChanged(ChangeEvent ce) {
        // get the transcript
        CellBase base = inputs.get("DNAPrepID");
        if (base != null){
            String dnaID = base.getValueAsString();

            // get the next design value
            BombModel bombModel = (BombModel)this.getModel();
            int n = 0;
            try {
                n = bombModel.nextBomb(dnaID,this.getRow());
            }catch(Exception exc){exc.printStackTrace();}

            this.setValue(Integer.toString(n));
            this.unlock();
            
        }
    }     
}
