/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.analysis.views;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;
import org.rhwlab.LMS.analysis.BombEvent;
import org.rhwlab.LMS.analysis.BombSelection;

/**
 *
 * @author gevirl
 */
public class TimeSeriesPlot extends JPanel {
    public TimeSeriesPlot(String attributeName,BombSelection select)throws Exception {
        Class beanClass = Class.forName("org.rhwlab.LMS.analysis.BombEvent");
        BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
        PropertyDescriptor[] descrs = beanInfo.getPropertyDescriptors();
        for (PropertyDescriptor descr : descrs){
            
            DefaultCategoryDataset dataSet = new DefaultCategoryDataset();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            if(descr.getName().equals(attributeName)){
                Method method = descr.getReadMethod();
                Set<Date> dates = select.getBombDates();
                double total = 0.0;
                int count = 0;                
                for (Date date : dates){
                    ++count;
                    String dateStr = format.format(date);
                    List<BombEvent> events = select.getBombEvents(date);
                    for (BombEvent event : events){
                        Object data = method.invoke(event);
                        String gene = event.GeneName();
                        double v=0.0;
                        if (data instanceof Integer){
                            v = (Integer)data;
                        } else if (data instanceof Double){
                            v = (Double)data;
                        }
                        total = total + v;
                        dataSet.addValue(v,gene,dateStr);
                    }
                }
                mean = total/count;
                
                JFreeChart chart = ChartFactory.createStackedBarChart
                        (select.getTitle(),"Bomb Date", attributeName, dataSet, PlotOrientation.VERTICAL,false,true,true);
                ChartPanel panel = new ChartPanel(chart);
                this.add(panel);
                return;
            }
        }
    }
    public Map getSummary(){
        TreeMap<String,Double> ret = new TreeMap<>();
        ret.put("Mean", mean);
        return ret;
    }
    double mean;
}
