/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.analysis.views;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.rhwlab.LMS.analysis.TrackingJoin;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */
public class StatusTrackingPanel extends JPanel {
    public StatusTrackingPanel(TrackingPanel trackingPanel,JPanel displayPanel)throws Exception {
        this.display = displayPanel;
        this.trackingPanel = trackingPanel;
        DefaultListModel model = new DefaultListModel();
        String sql = "Select distinct Status from LMSTracking order by Status";
        ResultSet rs = MySql.getMySql().execute(sql);
        while(rs.next()){
            model.addElement(rs.getString("Status"));
        }
        statusList = new JList(model);
        
        this.setLayout(new BoxLayout(this,BoxLayout.Y_AXIS));
        this.add(new JLabel("Status"));
        JScrollPane scroll = new JScrollPane(statusList);
        this.add(scroll);
        JButton submit = new JButton("Submit");
        submit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    submit();
                } catch (Exception exc){
                    exc.printStackTrace();
                }
            }
        });
        this.add(submit);
    }
    private void submit()throws Exception {
        List projects = trackingPanel.getSelectedProjects();
        //make a JTable for each status selected
        map.clear();
        for (Object obj : statusList.getSelectedValuesList()){
            String status = (String)obj;
            DefaultTableModel model = new DefaultTableModel();
            model.addColumn("Table");
            for (Object pObj : projects){
                model.addColumn((String)pObj);   
            }
            model.addColumn("Total");
            map.put(status, new JTable(model));
            totalsMap.put(status, new int[projects.size()]);
        }
        
        
        for (Object  obj : trackingPanel.getSelectedTables()){
            String table =  (String) obj;
            String joinName = trackingPanel.getTableName(table);
            TrackingJoin join = new TrackingJoin(joinName,table);
            
            for (Object sobj : statusList.getSelectedValuesList()){
                
                String status = (String)sobj;
                int[] colTotals = totalsMap.get(status);
                DefaultTableModel model = (DefaultTableModel)map.get(status).getModel();
                Object[] row = new Object[projects.size()+2];
                row[0] = table;
                int rowTotal = 0;
                for (int i=1 ; i<row.length-1 ; ++i){
                    String project = (String)projects.get(i-1);
                    Integer v = join.getCount(status, project);
                    row[i] = v;
                    if (v != null){
                        rowTotal = rowTotal + v;
                        colTotals[i-1] = colTotals[i-1] + v;
                    }
                    
                }
                row[row.length-1] = rowTotal;
                model.addRow(row);
            }
        }

        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel,BoxLayout.Y_AXIS));
        for (String status : map.keySet()){
            DefaultTableModel model = (DefaultTableModel)map.get(status).getModel();
            int[] colTotal = totalsMap.get(status);
            Object[] row = new Object[projects.size()+2];
            row[0] = "Total";
            int total = 0;
            for (int i=1 ; i<row.length-1;++i){
                row[i] = colTotal[i-1];
                total = total + colTotal[i-1];
            }
            row[row.length-1] = total;
            model.addRow(row);
            JPanel panel = new JPanel();
            panel.setBorder(BorderFactory.createRaisedBevelBorder());
            panel.setLayout(new BoxLayout(panel,BoxLayout.Y_AXIS)); 
            panel.add(new JLabel(status));
            JPanel tablePanel = new JPanel();
            tablePanel.setLayout(new BorderLayout());
            tablePanel.add(map.get(status).getTableHeader(),BorderLayout.PAGE_START);
            tablePanel.add(map.get(status),BorderLayout.CENTER);
            panel.add(tablePanel);
            mainPanel.add(panel);

        }
        JScrollPane scroll = new JScrollPane(mainPanel);
        display.add(scroll);        
    }
    public List getSelected(){
        return statusList.getSelectedValuesList();
    }
    public JTable getDisplayTable(String status){
        return map.get(status);
    }
    Map<String,JTable> map = new TreeMap<>();
    Map<String,int[]> totalsMap = new TreeMap<>();
    TrackingPanel trackingPanel;
    JPanel display;
    JList statusList;
}
