/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.analysis.views;

import java.awt.GridLayout;
import java.util.TreeMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/**
 *
 * @author gevirl
 */
public class PlotSelectionSummaryPanel extends JPanel implements ChangeListener{
    public PlotSelectionSummaryPanel() {
        this.setBorder(new TitledBorder("Plot Selection Summary"));
        main = new JPanel();
        this.add(main);
    }
    @Override
    public void stateChanged(ChangeEvent e) {
        TreeMap<String,Double> map = (TreeMap<String,Double>)e.getSource();
        main.removeAll();
        main.setLayout(new GridLayout(map.size(),1));
        for (String key : map.keySet()){
            Double value = map.get(key);
            JPanel panel = new JPanel();
            panel.add(new JLabel(key+": "));
            panel.add(new JLabel(String.format("%.2f",value)));
            main.add(panel);            
        }
        this.validate();
        this.repaint();
    }
    JPanel main;
}
