/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.analysis.views;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.rhwlab.LMS.analysis.BombSelection;
import org.rhwlab.LMS.analysis.ChooseBeanProperty;

/**
 *
 * @author gevirl
 */
public class PlotSelectionPanel extends JPanel implements ChangeListener {
    public PlotSelectionPanel(final JPanel plotsPanel) throws Exception {
        this.setBorder(new TitledBorder("Plot Selection"));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridLayout(6,1));

        JPanel plotPanel = new JPanel();
        plotPanel.add(new JLabel("Plot Type: "));
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        model.addElement("Time Series");
        model.addElement("Scatter");
        plotBox = new JComboBox(model);
        plotPanel.add(plotBox);
        mainPanel.add(plotPanel);
        
        JPanel yaxisPanel = new JPanel();
        yaxisPanel.add(new JLabel("Y Axis: "));
        yaxisBox = new ChooseBeanProperty(Class.forName("org.rhwlab.LMS.analysis.BombEvent"));
        yaxisPanel.add(yaxisBox);
        mainPanel.add(yaxisPanel);
 
        JPanel xaxisPanel = new JPanel();
        xaxisPanel.add(new JLabel("X Axis: "));
        xaxisBox = 
                new ChooseBeanProperty(Class.forName("org.rhwlab.LMS.analysis.BombEvent"));
        xaxisPanel.add(xaxisBox);
        mainPanel.add(xaxisPanel);
        
        JButton plotButton = new JButton("Plot");
        plotButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (plotBox.getSelectedItem().equals("Time Series")){
                    try {
                        TimeSeriesPlot plot = new TimeSeriesPlot((String)yaxisBox.getSelectedItem(),select);
                        plotsPanel.add(plot);
                        ChangeEvent event = new ChangeEvent(plot.getSummary());
                        for (ChangeListener listen : listeners){
                            listen.stateChanged(event);
                        }
                    } catch (Exception exc){
                        exc.printStackTrace();
                    }
                }else if (plotBox.getSelectedItem().equals("Scatter")){
                    try {
                        ScatterPlot plot = new ScatterPlot((String)xaxisBox.getSelectedItem(),(String)yaxisBox.getSelectedItem(),select);
                        plotsPanel.add(plot);
                        ChangeEvent event = new ChangeEvent(plot.getSummary());
                        for (ChangeListener listen : listeners){
                            listen.stateChanged(event);
                        }
                    } catch (Exception exc){
                        exc.printStackTrace();
                    }                    
                }
            }
        });
        mainPanel.add(plotButton);
        
        JButton tableButton = new JButton("Table");
        tableButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try{
                    SelectionTable table = new SelectionTable((String)yaxisBox.getSelectedItem(),select);
                    plotsPanel.add(table);
                } catch (Exception exc){
                    exc.printStackTrace();
                }
            }
        });
        mainPanel.add(tableButton);
        
        JButton clearButton = new JButton("Clear");
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                plotsPanel.removeAll();
            }
        });
        mainPanel.add(clearButton);
        
        this.add(mainPanel);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        select = (BombSelection)e.getSource();
    }

    public void addListener(ChangeListener listener){
        listeners.add(listener);
    }   
    List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    BombSelection select;
    JComboBox plotBox;
    ChooseBeanProperty yaxisBox;
    ChooseBeanProperty xaxisBox;
}
