/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.analysis.views;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.rhwlab.LMS.analysis.FilterCondition;
import org.rhwlab.LMS.analysis.FilteredTable;

/**
 *
 * @author gevirl
 */
public class FilterTablePanel extends JPanel {
 
    public FilterTablePanel(Frame frame,JPanel tableDisplay)throws Exception {
        this.setBorder(new TitledBorder("Table Filtering"));
        this.tableDisplay = tableDisplay;
        dialog = new FilterConditionDialog(frame);
        JPanel condListPanel = new JPanel();
        condListPanel.setLayout(new BoxLayout(condListPanel,BoxLayout.Y_AXIS));
        condListPanel.add(new JLabel("Conditions"));
        model = new DefaultListModel();
        condList = new JList(model);
        JScrollPane scroll = new JScrollPane(condList);
        condListPanel.add(scroll);
        JButton addButton = new JButton("Add a Condition");
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(true);
                FilterCondition cond = dialog.getCondition();
                if (cond != null){
                    model.addElement(cond);
                }
            }
        });
        condListPanel.add(addButton);
        
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel,BoxLayout.Y_AXIS));
        buttonPanel.add(andBox);
        buttonPanel.add(orBox);
        
        ButtonGroup group = new ButtonGroup();
        group.add(orBox);
        group.add(andBox);
        andBox.setSelected(true);
        
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel,BoxLayout.X_AXIS));
        topPanel.add(condListPanel);
        topPanel.add(buttonPanel);
        
        this.setLayout(new BoxLayout(this,BoxLayout.Y_AXIS));
        this.add(topPanel);
        JButton submit = new JButton("Submit the Filtering");
        submit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    submit();
                    ChangeEvent event = new ChangeEvent(FilterTablePanel.this);
                    for (ChangeListener listen : listeners){
                        listen.stateChanged(event);
                    }
                } catch (Exception exc){
                    exc.printStackTrace();
                }
            }
        });
        this.add(submit);
        
    }
    public void addListener(ChangeListener listen){
        listeners.add(listen);
    }
    private void submit()throws Exception {
        // sort the conditions by table
        TreeMap<String,List<FilterCondition>> condsMap = new TreeMap<>();
        List<FilterCondition> selectedList = condList.getSelectedValuesList();
        for (FilterCondition cond : selectedList){
            List<FilterCondition> list = condsMap.get(cond.getTable());
            if (list == null){
                list = new ArrayList<>();
                condsMap.put(cond.getTable(), list);
            }
            list.add(cond);
        }
        
        // build a temp table for each group of conditions
        tableDisplay.removeAll();
        tableMap.clear();
        for (String table : condsMap.keySet()){
            FilteredTable filterTable = new FilteredTable(condsMap.get(table),andBox.isSelected());
            tableMap.put(table, filterTable);
            JScrollPane scroll = new JScrollPane(filterTable.display());
            scroll.setBorder(new TitledBorder(table));
            tableDisplay.add(scroll);
        }
    }

    public Map<String,FilteredTable> getFilteredTables(){
        return this.tableMap;
    }
    // return the table to use in joins
    // will be the temp table if one has been created
    public String getTableName(String permTable){
        String ret = permTable;
        FilteredTable filtered = tableMap.get(permTable);
        if (filtered != null){
            ret = filtered.getTempTable();
        }
        return ret;
    }
    JPanel tableDisplay;
    FilterConditionDialog dialog;
    JList condList;
    DefaultListModel model;
    List<ChangeListener> listeners = new ArrayList<>();
    JCheckBox andBox = new JCheckBox("And");;
    JCheckBox orBox = new JCheckBox("Or");
    TreeMap<String,FilteredTable> tableMap = new TreeMap<>();  // indexed by permanent table name
    TreeMap<String,List<FilterCondition>> condsMap;   
}
