/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.analysis.views;

import java.awt.event.ContainerListener;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.rhwlab.LMS.analysis.FilteredTable;

/**
 *
 * @author gevirl
 */
public class FilterResultsPanel extends JPanel implements ChangeListener{
    public FilterResultsPanel(ContainerListener listen){
        this.listen = listen;
        this.setBorder(new TitledBorder("Filter Results"));
        model = new DefaultListModel();
        JList list = new JList(model);
        JScrollPane scroll = new JScrollPane(list);
        this.add(scroll);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        model.clear();
        FilterTablePanel tableFilter = (FilterTablePanel)e.getSource();
        Map<String,FilteredTable> map = tableFilter.getFilteredTables();
        for (String table : map.keySet()){
            FilteredTable filtered = map.get(table);
            int count = filtered.getCount();
            model.addElement(String.format("%s %d", table,count));
        }
        listen.componentAdded(null);
    }
    DefaultListModel model;
    ContainerListener listen;
}
