/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.analysis;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */
public class BombSelection {
    public BombSelection(Date start,Date end,String type,String group) throws Exception {
        this.constructType = type;
        this.endDate = end;
        this.geneGroup = group;
        this.startDate = start;
        bombCount = 0;
        PreparedStatement geneState = MySql.getMySql().getStatement("Select * from Gene where Gene = ?");
        PreparedStatement prepState =  MySql.getMySql().getStatement("Select * from DNAPrep where PrepID = ?");
        PreparedStatement fosmidState =  MySql.getMySql().getStatement("Select * from Fosmid where FosmidID = ?");
        PreparedStatement rescueState = MySql.getMySql().getStatement
                ("Select * from Rescue where BombID = ?");
        PreparedStatement intState = MySql.getMySql().getStatement("Select * from Integration where RescueID = ? and Percent = 100 and Integration = 2 ");
        
        PreparedStatement state;
        if (type.equals("Both")){
            state = MySql.getMySql().getStatement
                    ("select * from Bomb B  where B.BombDate <= ? and B.BombDate >= ? and (B.Construct = ? or B.Construct = ?)");
            state.setDate(1,new java.sql.Date(end.getTime()));
            state.setDate(2,new java.sql.Date(start.getTime()));
            
            state.setString(3,"Fosmid");
            state.setString(4,"Plasmid");
            state.execute();            
        }
        else {
            state = MySql.getMySql().getStatement
//                    ("select * from Bomb B join GeneGroups G on B.Gene=G.Gene where B.BombDate <= ? and B.BombDate >= ? and G.GroupName = ? and B.Construct = ?");
            ("select * from Bomb B  where B.BombDate <= ? and B.BombDate >= ? and B.Construct = ?");
            state.setDate(1,new java.sql.Date(end.getTime()));
            state.setDate(2,new java.sql.Date(start.getTime()));
            state.setString(3,type);

            state.execute();
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        title = String.format("%s to %s", format.format(start),format.format(end));
        ResultSet rs = state.getResultSet();
        while(rs.next()){
            ++bombCount;
            String bombID = rs.getString("BombID");
            Date bombDate = rs.getDate("BombDate");
            String prepID = rs.getString("DNAPrepID");
            String gene = rs.getString("Gene");
            List<BombEvent> bombList = bombMap.get(bombDate);
            if (bombList == null){
                bombList = new ArrayList<BombEvent>();
                bombMap.put(bombDate, bombList);
            }
            rescueState.setString(1, bombID);
            rescueState.execute();
            int dauers = 0;
            int integrates = 0;
            ResultSet resRS = rescueState.getResultSet();
            while (resRS.next()){
                int first = resRS.getInt("FirstIntegration");
                int second = resRS.getInt("SecondIntegration");
                String resID = resRS.getString("RescueID");
                if (first >0 || resRS.getBoolean("DauersPresent")){
                    ++dauers;
                }
                if (first==100 || second == 100){
                    ++integrates;
                } else {
                    intState.setString(1,resID);
                    intState.execute();
                    ResultSet intRS = intState.getResultSet();
                    if (intRS.next()){
                        ++integrates;
                    }
                }
            }   
            BombEvent event = new BombEvent(bombID,gene,bombList);
            bombList.add(event);
            event.setDauers(dauers);
            event.setIntegrations(integrates);
            
            prepState.setString(1, prepID);
            prepState.execute();
            ResultSet prepRS = prepState.getResultSet();
            String DNAId = "";
            if (prepRS.next()){
                DNAId = prepRS.getString("DNAId");
                double conc = prepRS.getDouble("Concentration");
                if (conc != 0.0){
                    event.setDNAConc(conc);
                }

            }
            if (type.equals("Fosmid")){
                fosmidState.setString(1, DNAId);
                fosmidState.execute();
                ResultSet fosmidRS = fosmidState.getResultSet();
                if (fosmidRS.next()){
                    int fosmidSize = fosmidRS.getInt("Size");
                    if (fosmidSize != 0){
                        event.setFosmidSize(fosmidSize);
                    }
                    String fosmidDescr = fosmidRS.getString("FosmidDescr");
                    if (fosmidDescr != null && !fosmidDescr.equals("")){
                        int i1 = fosmidDescr.indexOf('[');
                        int i2 = fosmidDescr.indexOf(']');
                        int pos = Integer.valueOf(fosmidDescr.substring(i1+1,i2));
                        event.setGeneLocationInFosmid(pos);
                    }
                }
            }            
            geneState.setString(1, gene);
            geneState.execute();
            ResultSet geneRS = geneState.getResultSet();
            if (geneRS.next()){
                int s = geneRS.getInt("Start");
                int e = geneRS.getInt("End");
                event.setGeneSize(e-s+1);
            }
        }        
    }
    public int getBombCount(){
        return this.bombCount;
    }  
    public int getBombDateCount(){
        return bombMap.keySet().size();
    }
    public Set<Date> getBombDates(){
        return bombMap.keySet();
    }
    public List<BombEvent> getBombEvents(Date date){
        return bombMap.get(date);
    }
    public String getTitle(){
        return title;
    }
    String title;
    int bombCount;
    TreeMap<Date,List<BombEvent>> bombMap = new TreeMap<Date,List<BombEvent>>();
    Date startDate;
    Date endDate;
    String geneGroup;
    String constructType;
}
