/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS;

import org.rhwlab.LMS.stock.GlycerolStockLine;
import java.sql.ResultSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ChangeEvent;
import org.rhwlab.db.MySql;
import org.rhwlab.spreadsheet.CellBase;

/**
 *
 * @author gevirl
 */
// the value can be either a DefaultComboBoxModel or a simple String
public class Transcript extends CellBase {
    public Transcript(){
        this("");
    }
    public Transcript(String value){
        super(value);
//        this.inputs.put("Sequence", this);
//        this.inputs.put("CGC", this);
    }

    public void setEditable(boolean edit){
        if (!edit){
            for (CellBase input : inputs.values()){
                if (input != null) input.setEditable(false);
            }
        }
        super.setEditable(edit);
    }
    public boolean setValue(Object val){
        return this.setValue(val,true);
    }
    
    public boolean setValue(Object val,boolean notify){
        if (val instanceof DefaultComboBoxModel){
            return super.setValue(val, notify);
        }
        String newValue = (String)val;
        if (super.getValue() instanceof DefaultComboBoxModel){
            // there is a list of transcripts already established
            DefaultComboBoxModel model =(DefaultComboBoxModel)super.getValue();
            int n = model.getSize();
            for (int i=0 ; i<n ; ++i){
                String modelValue = (String)model.getElementAt(i);
                if (newValue.equals(modelValue)){
                    model.setSelectedItem(modelValue);
                    super.cellHasBeenChanged();
                    return true;
                }
            }
        }
        
        // build the list with this new value as starting point or just save this value alone
        String sql = String.format("Select * from Transcript where TranscriptName=\'%s\'",newValue);
        try {
            ResultSet rs = MySql.getMySql().execute(sql);
            if (!rs.next()) {
                // no transcript matching the input exactly
                // try matching closely
                sql = String.format("Select * from Transcript where TranscriptName like \'%s",newValue)
                        + "%\'";
                rs = MySql.getMySql().execute(sql);
                if (!rs.next()) {
                    // try the wormbase transcripts
                    sql = String.format("Select * from WormBaseTranscript where Transcript=\'%s\'",newValue);
                    rs = MySql.getMySql().execute(sql);
                    if (!rs.next())
                        return super.setValue(newValue);
                }
            }
            // build a list of transcripts for the gene
            String wbGene = rs.getString("WBGene");
            DefaultComboBoxModel model = new DefaultComboBoxModel();
            sql = String.format("Select * from Transcript where WBGene=\'%s\'",wbGene);
            rs = MySql.getMySql().execute(sql);
            while(rs.next()){
                String transcript = rs.getString("TranscriptName");
                model.addElement(transcript); 
            }
            model.setSelectedItem(newValue);
            super.setValue(model,notify);
            this.unlock();
            return true;
        } catch (Exception exc){
            return false;
        }
    }
    public boolean validate(String newValue)  {
        if (!validate) return true;
        if (newValue.equals("")) return true;
        try {
            // check the database for valid Transcript
            String sql = String.format("Select * from Transcript where TranscriptName=\'%s\'",newValue);
            ResultSet rs = MySql.getMySql().execute(sql);
            if (rs.next()){
                return true;
            }
        } catch (Exception exc){ exc.printStackTrace();}
        return false;
    }  
    public void stateChanged(ChangeEvent event){
        if (locked) return;
        Object source = event.getSource();
        String newValue = ((CellBase)source).getValueAsString();
        if (newValue.equals(""))return;                        
        try {
            DefaultComboBoxModel comboBox = new DefaultComboBoxModel();
            String tran= null;
            if (source instanceof GlycerolStockLine){
                tran = ((GlycerolStockLine)source).getTranscript();
                if (tran != null){
                    comboBox.addElement(tran);
                }
            } else {
                String sql=null;
                if (source instanceof Sequence){
                    sql = String.format("Select T.TranscriptName from Transcript T,Gene G where "
                            + "T.WBGene=G.WBGene and G.Sequence=\'%s\'"
                            ,newValue);
                }else if (source instanceof CGC){
                    sql = String.format("Select T.TranscriptName from Transcript T,Gene G where "
                            + "T.WBGene=G.WBGene and G.CGC=\'%s\'"
                            ,newValue);
                } else if (source instanceof BooleanCell){
                    if (newValue.equals("1")){
                        this.setEditable(false);
                    }
                    return;
                }
                ResultSet rs = MySql.getMySql().execute(sql);
                while(rs.next()){
                    tran = rs.getString("TranscriptName");
                    comboBox.addElement(tran);
                }
            }       
                if (comboBox.getSize()==1){
                    comboBox.setSelectedItem(tran);
                } else {
                    comboBox.setSelectedItem(null);
                }
                super.setValue(comboBox);
            
        } catch(Exception exc){
            exc.printStackTrace();
            System.exit(0);
        }
    }

    @Override
    public String getValueAsString() {
        if (value instanceof String){
            return ((String)value).trim();
        } else if (value instanceof DefaultComboBoxModel){
            DefaultComboBoxModel box = (DefaultComboBoxModel)value;
            if (box.getSize()==1){
                return ((String)box.getElementAt(0)).trim();
            } else {
                Object sel = box.getSelectedItem();
                if (sel == null){
                    return "";
                } else {
                    if (!(sel instanceof String)){
                    }
                    return ((String)sel).trim();
                }
            }
        }
        return "";
    }
    @Override
    public int compareTo(Object o) {
        Transcript other = (Transcript)o;
        return this.getValueAsString().compareTo(other.getValueAsString());
    }    
}
