/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS;

import java.sql.ResultSet;
import javax.swing.event.ChangeEvent;
import org.rhwlab.db.MySql;
import org.rhwlab.spreadsheet.CellBase;

/**
 *
 * @author gevirl
 */
//  the sequence name of a gene
public class Sequence extends TextCell {
    public Sequence(){
        this("");
    }
    public Sequence(String value){
        super(value);
    }
    public boolean validate(String newValue)  {
        if (!validate) return true;
        if (newValue.equals("")) return true;
        try {
            // check the database for valid Sequence name
            String sql = String.format("Select * from Gene where Sequence=\'%s\'",newValue);
            ResultSet rs = MySql.getMySql().execute(sql);
            if (rs.next()){
                return true;
            }
        } catch (Exception exc){ exc.printStackTrace();}
        return false;
    }   
    public void stateChanged(ChangeEvent event){
        if (locked) return;
        Object source = event.getSource();
        String newValue = ((CellBase)source).getValueAsString();
        if (newValue.equals(""))return;
        
        try {
            String sql=null;
            if (source instanceof GeneName){
                GeneName geneNameCell = (GeneName)source;
                String geneName = geneNameCell.getValueAsString();
                sql = String.format("Select Sequence from WormBaseGene where CGC=\'%s\'",geneName);
                ResultSet rs = MySql.getMySql().execute(sql);
                if (rs.next()){
                    this.setValue(rs.getString("Sequence"));
                }else {
                    this.setValue(geneName);
                }
                return;
            }else if (source instanceof Transcript){
                sql = String.format("Select G.Sequence from Transcript T,Gene G where "
                        + "T.WBGene=G.WBGene and T.TranscriptName=\'%s\'"
                        ,newValue);
            } else if (source instanceof BooleanCell){
                if (newValue.equals("1")){
                    this.setEditable(false);
                }
                return;
            }else if (source instanceof WBGene ){
                sql = String.format("Select Sequence from Gene where WBGene=\'%s\'",newValue);
            }
            ResultSet rs = MySql.getMySql().execute(sql);
            if (rs.next())
                this.setValue(rs.getString("Sequence"));
        } catch(Exception exc){
            exc.printStackTrace();
            System.exit(0);
        }

    }    
}
