/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.RNASeq.merged;

import org.rhwlab.LMS.RNASeq.md5.*;

import java.io.File;
import java.io.PrintWriter;
import java.sql.PreparedStatement;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.JsonCell;
import org.rhwlab.LMS.RNASeq.GridSubmitOld;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */
public class BAMs extends JsonCell {
    public BAMs(){
        super();
        inputs.put("AlignmentID",null);
        inputs.put("Directory",null);
        inputs.put("Species",null);
    }
    public String getDirectory(){
        String[] files = this.getValueAsString().split(",");
        return new File(files[0]).getParent();
    }
    public void stateChanged(ChangeEvent event){    
        MD5sum md5 = (MD5sum)event.getSource();
        List<String> bams = md5.getBAMFiles();
        JsonArrayBuilder bamBuilder = Json.createArrayBuilder();
        for (String bam : bams){
            bamBuilder.add(bam);
        }
        this.setValue(bamBuilder.build());
    }

    public void submitRibosomalCounts()throws Exception {
        String species = inputs.get("Species").getValueAsString();
        String alignID = inputs.get("AlignmentID").getValueAsString();
        String directory = inputs.get("Directory").getValueAsString();
        File qsub = GridSubmitOld.qsubFile(alignID,"ReadCounts");
        PrintWriter writer = GridSubmitOld.initializeQsub(qsub, 16, 4, "sage");
        writer.println("module load java/8u25");
        String[] bams = this.getValueAsString().split(",");
        for (String bam : bams){
            if (bam.contains("Transcriptome")){
                writer.printf("java  -Xms16G -classpath /nfs/waterston/tools3/LabManagement.jar org.rhwlab.LMS.RNASeq.merged.BAMs ReadCounts %s %s %s \n",alignID,bam,species);
            }
        }
        writer.close();
        
        File script = GridSubmitOld.scriptFile(alignID, "ReadCounts", "Ribosomal");
        GridSubmitOld.writeScriptFile(script, new File(directory), qsub);        
        GridSubmitOld.startSubmission(script.getPath());
    }
    
    static void  ribosomalCount(String species,String mergedID,String xomebam){
        org.rhwlab.alignment.BAM file = new org.rhwlab.alignment.BAM(new File(xomebam));
        try {
            file.countRibosomalReads(species);
            int rRNACount = file.getRibosomalReadCount();
            PreparedStatement state = MySql.getMySql().getStatement("update RNASeqMerged set rRNAReadsXome = ? where MergedID = ?");
            state.setInt(1, rRNACount);
            state.setString(2,mergedID);
            state.execute();
        } catch (Exception exc){
            exc.printStackTrace();
        }        
    }
    static public void updateReadCounts(String mergedID) throws Exception {
        File directory = new File(MergedID.getDirectory(mergedID));
        String species = MergedID.getSpecies(mergedID);
        int genomeReads=0;
        int xomeReads=0;
        int rRNAReads=0;
        for (File file : directory.listFiles()){
            if (file.getName().endsWith("bam")){
                org.rhwlab.alignment.BAM bam = new org.rhwlab.alignment.BAM(file); 
                if (file.getName().contains("Transcriptome")){
                    bam.countRibosomalReads(species);
                    rRNAReads = bam.getRibosomalReadCount();
                    xomeReads = bam.getTotalReadCount();
                } else if(file.getName().contains("Genome")) {
                    genomeReads = bam.countReads();
                }
            }
        }
        PreparedStatement state = MySql.getMySql().getStatement(
                "update RNASeqMerged set rRNAReadsXome = ? , GenomeMappedReads = ? , XomeMappedReads = ? where MergedID = ?");
        state.setInt(1, rRNAReads);
        state.setInt(2, genomeReads);
        state.setInt(3, xomeReads);
        state.setString(4, mergedID);
        state.execute();
    }


    // args[0] - mergedID
    public static void main(String[] args)throws Exception {
        BAMs.updateReadCounts(args[0]);           
    }
    
}
