/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.RNASeq.md5;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import java.io.File;
import java.io.PrintWriter;
import java.sql.PreparedStatement;
import java.util.List;
import java.util.TreeMap;
import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.RNASeq.GridSubmitOld;
import org.rhwlab.LMS.TextCell;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */
public class BAMFile extends TextCell {
    public BAMFile(){
        super();
        inputs.put("AlignmentID",null);
        inputs.put("Directory",null);
        inputs.put("Species",null);
    }
    public String getDirectory(){
        String[] files = this.getValueAsString().split(",");
        return new File(files[0]).getParent();
    }
    public void stateChanged(ChangeEvent event){    
        MD5sum md5 = (MD5sum)event.getSource();
        List<String> bams = md5.getBAMFiles();
        StringBuilder buffer = new StringBuilder();
        Boolean first = true;
        for (String bam : bams){
            if (!first) buffer.append(",");
            buffer.append(bam);
            first = false;
        }
        this.setValue(buffer.toString());
    }
    // add up the counts for the reference names in the bam file
    public TreeMap<String,Double> referenceCounts(){
        TreeMap<String,Double> ret = new TreeMap<>();
        File bamFile = new File(this.getValueAsString());
        SamReader samReader = SamReaderFactory.makeDefault().open(bamFile);
        SAMRecordIterator iter = samReader.iterator();
        while (iter.hasNext()){
            SAMRecord record = iter.next(); 
            String ref = record.getReferenceName();
            Integer nh = (Integer)record.getAttribute("NH");
            
            Double count = ret.get(ref);
            if (count == null){
                ret.put(ref,1.0/nh);
            } else {
                ret.put(ref, count+1.0/nh);
            }
        }
        return ret;
    }
    public void submitRibosomalCounts()throws Exception {
        String species = inputs.get("Species").getValueAsString();
        String alignID = inputs.get("AlignmentID").getValueAsString();
        String directory = inputs.get("Directory").getValueAsString();
        File qsub = GridSubmitOld.qsubFile(alignID,"ReadCounts");
        PrintWriter writer = GridSubmitOld.initializeQsub(qsub, 16, 4, "sage");
        writer.println("module load java/8u25");
        String[] bams = this.getValueAsString().split(",");
        for (String bam : bams){
            if (bam.contains("Transcriptome")){
                writer.printf("java  -Xms16G -classpath /nfs/waterston/tools3/LabManagement.jar org.rhwlab.LMS.RNASeq.md5.BAMFile ReadCounts %s %s %s \n",alignID,bam,species);
            }
        }
        writer.close();
        
        File script = GridSubmitOld.scriptFile(alignID, "ReadCounts", "Ribosomal");
        GridSubmitOld.writeScriptFile(script, new File(directory), qsub);        
        GridSubmitOld.startSubmission(script.getPath());
    }
    
    static public void  ribosomalCount(String species,String alignID,String bam){
        org.rhwlab.alignment.BAM file = new org.rhwlab.alignment.BAM(new File(bam));
        try {
            file.countRibosomalReads(species);
            int rRNACount = file.getRibosomalReadCount();
            PreparedStatement state = MySql.getMySql().getStatement("update RNASeqIndividualAlign set rRNAReads = ? where AlignmentID = ?");
            state.setInt(1, rRNACount);
            state.setString(2,alignID);
            state.execute();
        } catch (Exception exc){
            exc.printStackTrace();
        }        
    }
    // annotate the bam file with splice leaders and adapters 
    public void submitSLAnnotation()throws Exception {
        String scriptFile = makeSLScript();

        // start the annotating script running 
        ProcessBuilder pb = new ProcessBuilder("ssh","grid.gs.washington.edu",scriptFile);
        Process p = pb.start();         
    }

    private String makeSLScript()throws Exception {
        String alignID = inputs.get("AlignmentID").getValueAsString();
        File bamFile = new File(this.getValueAsString());
        File alignDir = bamFile.getParentFile();
        File scriptFile = GridSubmitOld.scriptFile(alignID,"SLAnnotating","BAM");
        File qsubFile = GridSubmitOld.qsubFile(alignID,"SLAnnotating");
        
         // build the script file for this archiving of fastq
        PrintWriter writer = new PrintWriter(scriptFile);
        writer.println("#! /bin/bash");  
        writer.printf("mkdir -p %s\n",alignDir);  
        writer.printf("qsub -e %s -o %s %s\n", alignDir,alignDir,qsubFile.getPath());
        writer.close();
        scriptFile.setReadable(true,false);
        scriptFile.setExecutable(true, false);
        scriptFile.setWritable(true, false); 
        
        // build the qsub file
        writer = new PrintWriter(qsubFile);
        writer.println("#$ -S /bin/bash");
        writer.println("#$ -l mfree=2G");
        writer.println("#$ -l h_rt=96:0:0");
        writer.println("date"); 

        writer.printf("cd %s\n",alignDir);
        writer.println("module load samtools/1.2");
        String outSam = bamFile.getPath().replace(".bam", ".annotated.sam");
        String outBam = bamFile.getPath().replace(".bam", ".annotated.bam");
        writer.printf("samtools view -h %s | /nfs/waterston/transcriptome/software/src/samedit/samedit.pl > %s 2> /dev/null \n",bamFile.getPath(),outSam);
        writer.printf("samtools view -b %s > %s \n",outSam,outBam);
        writer.printf("rm -f  %s\n",outSam);
        writer.close(); 
        
        qsubFile.setReadable(true,false);
        qsubFile.setExecutable(true, false);
        qsubFile.setWritable(true, false);        
        return scriptFile.getPath();
    }

    // args[0] - function
    // args[1] - alignmentID
    // args[2] = bam file name
    // args[3] - species
    public static void main(String[] args){
        String fnc = args[0];
        if (fnc.equals("ReadCounts")){
            BAMFile.ribosomalCount(args[3],args[1], args[2]);           
        }
    }
    
}
