/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.RNASeq;

import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import org.apache.commons.math3.stat.StatUtils;
import org.rhwlab.DAG.decomp.PMatrix;
import org.rhwlab.LMS.TextCell;
import org.rhwlab.RNASeq.DataSource;
import org.rhwlab.RNASeq.ExperimentDataSource;
import org.rhwlab.RNASeq.KdeFile;
import org.rhwlab.RNASeq.PMatrixKdeFile;
import org.rhwlab.db.MySql;
import org.rhwlab.spreadsheet.CellBase;

/**
 *
 * @author gevirl
 */
// RNASeq Expression calculators
public class UnificationID extends TextCell {
    public UnificationID(){
        super("");
        inputs.put("User",null);
        inputs.put("Name",null);
        inputs.put("Directory",null);
        inputs.put("TimeSeries",null);
        
        
    }
    public void stateChanged(ChangeEvent event){
        String unique = ((CellBase)event.getSource()).getValueAsString();
        String condition = inputs.get("Name").getValueAsString();
        if (condition.equals(""))return;
        String user = inputs.get("User").getValueAsString();
        if (user.equals(""))return; 
        this.setValue(String.format("%s_%s_%s", user,condition,unique));
    }    
    static File getDirectory(String uniID)throws Exception {
        File ret = null;
        PreparedStatement state = MySql.getMySql().getStatement("Select Directory from RNASeqUnification where UnificationID =? ");
        state.setString(1, uniID);
        ResultSet rs = state.executeQuery();
        if (rs.next()){
            ret = new File(rs.getString("Directory"));
        }
        return ret;
    }
    public double rmsError()throws Exception {
        String dir = inputs.get("Directory").getValueAsString();
        String[] dataFiles = ((TimeSeriesMap)inputs.get("TimeSeries")).getTimeSeries();
        return rmsError(this.getValueAsString(),new File(dir),dataFiles);
    }
    static public double rmsError(String unificationID,File resultsDirectory,String[] dataFiles) throws Exception {
        double e = 0.0;
        int n = 0;
        KdeFile results = Unification.DeconvolutionResults(resultsDirectory);  // this is the Z matrix from the unification
        
        DataSource source = new DataSource(resultsDirectory,dataFiles);
        String[] experiments = source.getExperiments();
        Set<String> genes = source.getFeatures();
        PMatrixKdeFile pkde = new PMatrixKdeFile();
        File config = new File(resultsDirectory,"DeconvolutionConfig");
        pkde.setFile(config.getPath());
        for (String experiment : experiments){
            ExperimentDataSource expSource = source.getExperimentSource(experiment);
            double[] sampleTimes = expSource.getTimes();  
            int nStages = pkde.getValue("NStages","Value").intValue();
            PMatrix P = new PMatrix(nStages,sampleTimes,experiment,null,pkde);
            for (String gene : genes){
                double[] expData = expSource.getFeatureData(gene);  // not normalized
                double mu = StatUtils.mean(expData);
                double sig = Math.sqrt(StatUtils.variance(expData,mu));
                for (int i=0 ; i< expData.length ; ++i){
                    expData[i] = (expData[i]-mu)/sig;
                }
                
                double[] z = results.getValues(gene, "Mode");  // normalized for the gene
                for (int i=0 ; i<expData.length ; ++i){
                    double v = 0.0;
                    double[] p = P.getColumn(i);
                    for (int j=0 ; j<p.length ; ++j){
                        v = v + z[j]*p[j];
                    }
                    double d = expData[i] - v;
                    e = e + d*d;
                    ++n;
                }
            }
        }

        return Math.sqrt(e)/n;
    }
    
}
