/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.RNASeq;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import org.rhwlab.DAG.decomp.Config;
import org.rhwlab.DAG.pipeline.Demux;
import org.rhwlab.DAG.pipeline.KDE;
import org.rhwlab.DAG.pipeline.MCMC;
import org.rhwlab.DAG.pipeline.NormalizeFeatures;
import org.rhwlab.RNASeq.DataSource;
import org.rhwlab.RNASeq.KdeFile;
import org.rhwlab.RNASeq.PMatrixKdeFile;

/**
 *
 * @author gevirl
 */

public class Unification {
    public Unification(String[] args)throws Exception {
        // read the time series data 
        String[] exp = new String[args.length-3];
        for (int i=0 ; i<exp.length ; ++i){
            exp[i]=args[i+3];
        } 
        source = new DataSource(exp);
        directory = exp[0];
        uniDirectory = args[2];
    }

    private void normalize()throws Exception {
        NormalizeFeatures norm = new NormalizeFeatures();
        File dirFile = new File(directory);
        File[] allFiles = dirFile.listFiles();
        ArrayList<KdeFile> kdes = new ArrayList<>();
        for (File file : allFiles){
            String name = file.getName();
            if (name.endsWith(".kde")){
                if (name.startsWith("DeconvolutionGenes")){
                    KdeFile kde = new KdeFile(file.getPath());
                    kdes.add(kde);
                }
            }
        }
        norm.setKDEFile(kdes);
        norm.setSource(source);
        norm.setOutFile("Normalized.out");
        norm.run();
    }
    private void training()throws Exception {

        // read the Report variable file
        varList = new ArrayList<>();
        BufferedReader reader = new BufferedReader(new FileReader(new File(directory,"ReportVariables")));
        String line = reader.readLine();
        while (line != null){
            varList.add(line);
            line = reader.readLine();
        }
        reader.close();

        // construct the pMatrix input
        pFile = new PMatrixKdeFile(new File(directory,"TrainingConfig").getPath());
        prefix = new File(directory,"Training").getPath();  
        mcmc();
    }
    private void timewarping() throws  Exception {
        // read the Report variable file
        varList = new ArrayList<>();
        BufferedReader reader = new BufferedReader(new FileReader(new File(directory,"ReportVariables")));
        String line = reader.readLine();
        while (line != null){
            varList.add(line);
            line = reader.readLine();
        }
        reader.close();
        
        // collect all the kde file names
        int i=0;
        ArrayList<String> fileList = new ArrayList<>();
        File file = new File(uniDirectory,String.format("DeconvolutionGenes.%d.kde",i));
        while (file.exists()){
            fileList.add(file.getPath());
            ++i;
            file = new File(uniDirectory,String.format("DeconvolutionGenes.%d.kde",i));
        }
        
        // build the kdeFile for the Z matrix
        zFile = new KdeFile();  
        zFile.setFile(fileList);
        
        // construct the pMatrix input
        pFile = new PMatrixKdeFile(new File(uniDirectory,"TrainingConfig").getPath());
        prefix = new File(directory,"Timewarping").getPath();  
        mcmc();        
        
    }    
    private void deconvolution(String featureListFile)throws Exception {
        source.setFeatureListFile(new File(directory,featureListFile).getPath());

        // construct the pMatrix input
        pFile = new PMatrixKdeFile(new File(directory,"DeconvolutionConfig").getPath());    
        prefix = new File(directory,"Deconvolution"+featureListFile).getPath();    
        mcmc();
    }
    static public KdeFile DeconvolutionResults(File resultsDir)throws Exception {
        // collect all the kde file names
        int i=0;
        ArrayList<String> fileList = new ArrayList<>();
        File file = new File(resultsDir,String.format("DeconvolutionGenes.%d.kde",i));
        while (file.exists()){
            fileList.add(file.getPath());
            ++i;
            file = new File(resultsDir,String.format("DeconvolutionGenes.%d.kde",i));
        } 
        KdeFile kdeFile = new KdeFile();
        kdeFile.setFile(fileList);
        return kdeFile;
    }
    private void mcmc()throws Exception {

        // run the Markov chain
        int n = pFile.getValue("NStages", "Value").intValue();
        int iter = pFile.getValue("Iterations", "Value").intValue();
        int burn = pFile.getValue("BurnIn", "Value").intValue();
        Config config = new Config(n,iter,burn);

        MCMC mcmc = new MCMC(prefix,source,config,pFile,varList);
        mcmc.setZ(this.zFile);
        mcmc.run();

        // demux the joint dirtribution
        Demux demux = new Demux();
        demux.setJPDFile(prefix);
        demux.init();
        demux.run();

        // estimate the densities
        KDE kde = new KDE();
        kde.setMarginals(prefix);
        kde.run();        
    }
    String directory;
    DataSource source;
    String prefix=null;
    PMatrixKdeFile pFile=null;
    KdeFile zFile = null;
    
    ArrayList<String> varList = null;  
    String uniDirectory;
    
    
// args[0]  -  Training ,Deconvolution ,Normalization, TimeWarping
// args[1] - gene list file
// args[2] - unification directory
// args[3] - data source directory (may be the same as the unification directory)    
// args[4+]  - data files for each time series       
    static public void main(String[] args)throws Exception {
        Unification unify = new Unification(args);
        
        if (args[0].equals("Training")){
            unify.training();
        } else if (args[0].equals("Deconvolution")){
            unify.deconvolution(args[1]);
        } else if (args[0].equals("Normalize")){
            unify.normalize();
        } else if (args[0].equals("Timewarping")){
            unify.timewarping();
        }
    }
}
