/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.RNASeq;

import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Date;
import javax.json.JsonArray;
import javax.swing.event.ChangeEvent;
import org.rhwlab.DAG.decomp.PMatrix;
import static org.rhwlab.LMS.RNASeq.GridSubmitOld.qsubFile;
import static org.rhwlab.LMS.RNASeq.GridSubmitOld.scriptFile;
import org.rhwlab.LMS.TextCell;
import org.rhwlab.spreadsheet.CellBase;

/**
 *
 * @author gevirl
 */

public class TimeWarpID extends TextCell {
    public TimeWarpID(){
        super("");
        inputs.put("TimeSeriesID",null);
        inputs.put("Directory",null);
        inputs.put("Features",null);
        inputs.put("UnificationID",null);        
        inputs.put("ExpressionIDs",null);
        inputs.put("Submitted",null);
        inputs.put("Completed",null);
    }
    public void stateChanged(ChangeEvent event){
        String unique = ((CellBase)event.getSource()).getValueAsString();
        String timeSeriesID = inputs.get("TimeSeriesID").getValueAsString();
        if (timeSeriesID.equals(""))return;
        this.setValue(String.format("%s_%s",timeSeriesID,unique));
    }
    public void submit()throws Exception {
        tsID = inputs.get("TimeSeriesID").getValueAsString();
        uniID = inputs.get("UnificationID").getValueAsString();
        String dir = inputs.get("Directory").getValueAsString();
        
        warpDir = new File(dir);
        if (!warpDir.exists()) warpDir.mkdirs();
        
        // build the time series data file
        FeatureGroup group = (FeatureGroup)((Features)inputs.get("Features")).getSelectedValue();
        JsonArray repArray = (JsonArray)(inputs.get("ExpressionIDs").getValue());
        String[] expIDs = new String[repArray.size()];
        for (int i=0 ; i<expIDs.length ; ++i){
            expIDs[i] = repArray.getString(i);
        }
        File outFile = new File(dir,tsID);
        TimeSeriesMap.buildBitSeqTimeSeriesFile(group, expIDs, outFile);
        
        // build the report variable file
        PrintStream outStream = new PrintStream(new File(warpDir,"ReportVariables"));  
        outStream.println(PMatrix.getStartTimeVariableName(tsID));
        outStream.println(PMatrix.getGrowthRateVariableName(tsID));
        outStream.println(PMatrix.getInitialVarianceVariableName(tsID));
        outStream.println(PMatrix.getDispersionRateVariableName(tsID));
        outStream.close(); 
        
        String scriptFile = makeScript();
        
        // start the expression script running 
        ProcessBuilder pb = new ProcessBuilder("ssh","grid.gs.washington.edu",scriptFile);
        Process p = pb.start();  

        inputs.get("Submitted").setValue(new Date());
        inputs.get("Completed").setValue(null);
    }   
    
    private String makeScript()throws Exception {
        File scriptFile = scriptFile(this.getValueAsString(),"Unification","Timewarping");
        File qsubFile = qsubFile(this.getValueAsString(),"Unification");  
        File uniDir = UnificationID.getDirectory(uniID);
        
         // build the script file for this training 
        PrintWriter writer = new PrintWriter(scriptFile);
        writer.println("#! /bin/bash");  

        writer.printf("qsub -e %s -o %s %s\n", warpDir.getPath(),warpDir.getPath(),qsubFile.getPath());
        writer.close();
        scriptFile.setReadable(true,false);
        scriptFile.setExecutable(true, false);
        scriptFile.setWritable(true, false);     
        
        // build the qsub file
        writer = new PrintWriter(qsubFile);
        writer.println("#$ -S /bin/bash");
        writer.println("#$ -l mfree=8G");
        writer.println("date"); 
        writer.printf("cd %s\n",warpDir.getPath());
        writer.printf(
                "/nfs/waterston/celtdModel/jdk1.7.0/bin/java -jar -Xms4G /nfs/waterston/tools3/Unification.jar Timewarping none %s %s %s \n",
                uniDir.getPath(),warpDir.getPath(),tsID); 

        writer.println("echo \"Starting RNASeqFinisher\"");
        writer.println("module load java/8u25");
        writer.printf("java  -jar -Xms2G /nfs/waterston/tools3/RNASeqFinisher.jar %s Timewarping \n",this.getValueAsString()); 
        writer.printf("chown -R :waterstonlab %s\n",warpDir.getPath());
        writer.printf("chmod -R 770 %s\n",warpDir.getPath());
        writer.close();        
        return scriptFile.getPath();
    }
    String tsID;
    String uniID;
    File warpDir;
      
}
