/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.RNASeq;

import java.io.File;
import java.io.PrintWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.TextCell;
import org.rhwlab.db.MySql;
import org.rhwlab.grid.GridSubmit;
import org.rhwlab.spreadsheet.GridSubmittable;

/**
 *
 * @author gevirl
 */
public class SequencingID extends TextCell  implements GridSubmittable {
    public SequencingID(){
        super();
        inputs.put("LibraryID",null);
        inputs.put("Platform",null);
        inputs.put("Count",null);
        inputs.put("Directory", null);
        inputs.put("Fastq1List", null);
        inputs.put("Fastq2List", null);
        inputs.put("Fastq1Archive", null);
        inputs.put("Fastq2Archive", null);
    }

    @Override
    public void submit(String program, int cores, int memory, int hours, String queue, String arrayjob, int concurrent) throws Exception {
        String dir = inputs.get("Directory").getValueAsString();
        File dirFile = new File(dir);
        String seqID = this.getValueAsString();
        
        GridSubmit gs = new GridSubmit(seqID,program,dirFile);
        gs.setRuntime(hours);
        gs.setMemory(memory);
        gs.setSlots(cores);
        gs.setQueue(queue);
        PrintWriter qsubStream = gs.initializeQsub();
        
        qsubStream.println("rm -f *.gz");
        String fastq = inputs.get("Fastq1List").getValueAsString();
        inputs.get("Fastq1Archive").setValue(catFastq(seqID,dir,fastq,qsubStream,"pair1"));
        fastq = inputs.get("Fastq2List").getValueAsString();
        if (!fastq.equals("\n")){
            inputs.get("Fastq2Archive").setValue(catFastq(seqID,dir,fastq,qsubStream,"pair2"));
        } 
        ArrayList<String> args = new ArrayList<>();
        args.add(seqID);
        args.add("Archive");
        gs.runJavaClass("/nfs/waterston/tools3/LabManagement.jar","org.rhwlab.LMS.RNASeq.Finisher" , args);  
        
        gs.run();
    }
    
    public void submit()throws Exception {
        String scriptFile = makeScript();

        // start the alignment script running 
        ProcessBuilder pb = new ProcessBuilder("ssh","grid.gs.washington.edu",scriptFile);
        Process p = pb.start();  

        
    }  
    private String makeScript()throws Exception {
        String seqID = this.getValueAsString();
        String archiveDir = inputs.get("Directory").getValueAsString();
        File scriptFile = GridSubmitOld.scriptFile(seqID,"Archive","Fastq");
        File qsubFile = GridSubmitOld.qsubFile(seqID,"Archive");
        
         // build the script file for this archiving of fastq
        PrintWriter writer = new PrintWriter(scriptFile);
        writer.println("#! /bin/bash");  
        writer.printf("mkdir -p %s\n",archiveDir);  
        writer.printf("qsub -e %s -o %s %s\n", archiveDir,archiveDir,qsubFile.getPath());
        writer.close();
        scriptFile.setReadable(true,false);
        scriptFile.setExecutable(true, false);
        scriptFile.setWritable(true, false);    
        
        // build the qsub file
        writer = new PrintWriter(qsubFile);
        writer.println("#$ -S /bin/bash");
        writer.println("#$ -l mfree=2G");
        writer.println("#$ -l h_rt=96:0:0");
        writer.println("date"); 

        writer.printf("cd %s\n",archiveDir);
        
        writer.println("rm -f *.gz");
        String fastq = inputs.get("Fastq1List").getValueAsString();
        inputs.get("Fastq1Archive").setValue(catFastq(seqID,archiveDir,fastq,writer,"pair1"));
        fastq = inputs.get("Fastq2List").getValueAsString();
        if (!fastq.equals("\n")){
            inputs.get("Fastq2Archive").setValue(catFastq(seqID,archiveDir,fastq,writer,"pair2"));
        }

        writer.println("date");
        writer.println("echo \"Starting RNASeqFinisher\"");
        writer.println("module load java/8u25");
        writer.printf("java  -jar -Xms2G /nfs/waterston/tools3/RNASeqFinisher.jar %s Archive \n",seqID); 
        writer.close(); 
        
        qsubFile.setReadable(true,false);
        qsubFile.setExecutable(true, false);
        qsubFile.setWritable(true, false);
        
        return scriptFile.getPath();
    }  
    private String catFastq(String runID,String alignDir,String fastq,PrintWriter writer,String prefix){
        if (fastq!=null && !fastq.equals("")){
            String fileName = String.format("%s.%s.fastq",runID,prefix);
            String gzName = String.format("%s.%s.fastq.gz",runID,prefix);
            File outFile = new File(alignDir,fileName);
            File gzFile = new File(alignDir,gzName);
            
            String[] files = fastq.split("\n");
            for (String file : files){
                if (file.endsWith(".gz")){
                    writer.printf("zcat %s >> %s\n",file,outFile.getPath());
                } else {
                    writer.printf("cat %s >> %s\n",file,outFile.getPath());
                }  
            }
            writer.printf("gzip %s\n", outFile.getPath());
            writer.printf("chmod 444 %s.gz\n", outFile.getPath());
            
            return gzFile.getPath();
        }
        return null;
    }    
    public void stateChanged(ChangeEvent event){
        String unique = inputs.get("Count").getValueAsString();
        if (unique.equals("")) return;
        String library = inputs.get("LibraryID").getValueAsString();
        if (library.equals(""))return;
        String platform = inputs.get("Platform").getValueAsString();
        if (platform.equals("")) return;
        
        this.setValue(String.format("%s_%s_%s",platform,library,unique));
    }
    // return the library ID of this sequencing ID
    public String libraryID(){
        String seqID = this.getValueAsString();
        return libraryID(seqID);
    }
    static public String libraryID(String seqID){
        int start = seqID.indexOf('_');
        int end = seqID.lastIndexOf('_');
        return seqID.substring(start+1, end);        
    }
    static public String getDirectory(String id) throws Exception{
        String sql = "Select Directory from RNASequencing where SequencingID = ?";
        PreparedStatement state = MySql.getMySql().getStatement(sql);
        state.setString(1, id);
        ResultSet rs = state.executeQuery();
        if (rs.next()){
            return rs.getString("Directory");
        }
        return null;
    }

}
