/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.RNASeq;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import org.rhwlab.LMS.TextCell;

/**
 *
 * @author gevirl
 */
public class PCRDupRate extends TextCell {
    public PCRDupRate(){
        super();
        inputs.put("SequencingID",null);
        inputs.put("Directory",null);
    }

    public void submitSeldup(String alignID)throws Exception {
        
        String scriptFile = makeSeldupScript(AlignmentID.getDirectory(alignID));

        // start the alignment script running 
        ProcessBuilder pb = new ProcessBuilder("ssh","grid.gs.washington.edu",scriptFile);
        Process p = pb.start();  

    } 
    public void submitRemoveDups() throws Exception {
        File seqDir = new File(inputs.get("Directory").getValueAsString());
        File rmdupList = new File(seqDir,"seldup.out.rmdup.lst");
        if (!rmdupList.exists()) return;
        
        BufferedReader reader = new BufferedReader(new FileReader(rmdupList));
        String line = reader.readLine();
        String[] tokens = line.split("\\|");
        String bam = tokens[2].trim();
        reader.close();
        
        String scriptFile = makeRemoveDupScript(seqDir,bam);
        
        // start the alignment script running 
        ProcessBuilder pb = new ProcessBuilder("ssh","grid.gs.washington.edu",scriptFile);
        Process p = pb.start();          
    }
    private String makeRemoveDupScript(File seqDir,String bam)throws Exception {
        String seqID = inputs.get("SequencingID").getValueAsString();
        File scriptFile = GridSubmitOld.scriptFile(seqID,"RemoveDup","RemoveDups");
        File qsubFile = GridSubmitOld.qsubFile(seqID,"RemoveDup");
        
         // build the script file for this alignment 
        PrintWriter writer = new PrintWriter(scriptFile);
        writer.println("#! /bin/bash");   
        writer.printf("qsub -e %s -o %s %s\n", seqDir.getPath(),seqDir.getPath(),qsubFile.getPath());
        writer.close();
        scriptFile.setReadable(true,false);
        scriptFile.setExecutable(true, false);
        scriptFile.setWritable(true, false);

        // build the qsub file
        writer = new PrintWriter(qsubFile);
        writer.println("#$ -S /bin/bash");
        writer.println("#$ -l mfree=32G");
        writer.println("#$ -l h_rt=200:0:0");
        writer.println("#$ -P sage");
        writer.println("date"); 

        writer.printf("cd %s\n",seqDir.getPath());
        writer.println("module load samtools/1.3");
        writer.printf("samtools view -h %s | /net/waterston/vol9/rmdupsam - seldup.out.rmdup.lst 2> rmdupsam.out | samtools view -b | samtools sort -n - | samtools fastq - -1 %s.nodups.pair1.fastq -2 %s.nodups.pair2.fastq\n",bam,seqID,seqID);
        writer.printf("gzip -f %s.nodups.pair1.fastq\n", seqID);
        writer.printf("chmod 444 %s.nodups.pair1.fastq.gz\n", seqID);
        writer.printf("gzip -f %s.nodups.pair2.fastq\n", seqID);
        writer.printf("chmod 444 %s.nodups.pair2.fastq.gz\n", seqID);
        writer.println("date");
        writer.println("echo \"Starting RNASeqFinisher\"");
        writer.println("module load java/8u25");
        writer.printf("java  -jar -Xms2G /nfs/waterston/tools3/RNASeqFini hsher.jar %s RemoveDup \n",seqID);     
        writer.close(); 
        qsubFile.setReadable(true,false);
        qsubFile.setExecutable(true, false);
        qsubFile.setWritable(true, false);
        
        return scriptFile.getPath();        
    }    
    private String makeSeldupScript(String alignDir)throws Exception{
        File bamFile = new File(alignDir,"Aligned.sortedByCoord.out.bam");
        String seqID = inputs.get("SequencingID").getValueAsString();
        File scriptFile = GridSubmitOld.scriptFile(seqID,"Seldup","Calc");
        File qsubFile = GridSubmitOld.qsubFile(seqID,"Seldup");
        
        File workingDir = new File(inputs.get("Directory").getValueAsString());
        
         // build the script file for this alignment 
        PrintWriter writer = new PrintWriter(scriptFile);
        writer.println("#! /bin/bash"); 
        writer.printf("qsub -e %s -o %s %s\n", workingDir.getPath(),workingDir.getPath(),qsubFile.getPath());
        writer.close();
        scriptFile.setReadable(true,false);
        scriptFile.setExecutable(true, false);
        scriptFile.setWritable(true, false);
        
        // build the qsub file
        writer = new PrintWriter(qsubFile);
        writer.println("#$ -S /bin/bash");
        writer.println("#$ -l mfree=32G");
        writer.println("#$ -l h_rt=200:0:0");
        writer.println("#$ -P sage");
        writer.println("date");     
        
        writer.printf("cd %s\n",workingDir.getPath());
        writer.println("echo \"Starting Seldup\"");        
        writer.printf("/net/waterston/vol9/seldup %s seldup.out 1 2\n",bamFile.getPath());
        writer.println("echo \"Starting RNASeqFinisher\"");
        writer.println("module load java/8u25");
        writer.printf("java  -jar -Xms2G /nfs/waterston/tools3/RNASeqFinisher.jar %s Seldup \n",seqID);         
        writer.close(); 
        qsubFile.setReadable(true,false);
        qsubFile.setExecutable(true, false);
        qsubFile.setWritable(true, false);
        
        return scriptFile.getPath();        
    }
}
