/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.RNASeq;

import java.sql.ResultSet;
import java.util.List;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonStructure;
import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.DCCResponse;
import org.rhwlab.LMS.JsonCell;
import org.rhwlab.LMS.TextCell;
import org.rhwlab.db.MySql;
import org.rhwlab.spreadsheet.CellBase;
import org.rhwlab.spreadsheet.config.JsonConfig;

/**
 *
 * @author gevirl
 */
public class LibraryID extends TextCell {
    public LibraryID(){
        super();
        inputs.put("SampleID",null);
    }
    public void stateChanged(ChangeEvent event){
        String unique = ((CellBase)event.getSource()).getValueAsString();
        String sample = inputs.get("SampleID").getValueAsString();
        if (sample.equals(""))return;

        this.setValue(String.format("%s_%s", sample,unique));
    } 
    static public String getSampleID(String ID)throws Exception {
        String sql = String.format("Select SampleID from RNASeqLibrary where LibraryID=\"%s\"",ID);
        ResultSet rs = MySql.getMySql().execute(sql);
        if (rs.next()){
            return rs.getString("SampleID");
        } else {
            return null;
        }
           
    }
    static public String getUUID(String expAlias,int rep)throws Exception {
        JsonObject expObj = JsonConfig.getFromDCC("www.encodeproject.org","experiments", expAlias);
        JsonArray replicates = expObj.getJsonArray("replicates");
        for (int i=0 ; i<replicates.size() ; ++i){
            JsonObject replicate = replicates.getJsonObject(i);
            int bioRep = replicate.getInt("biological_replicate_number");
            int techRep = replicate.getInt("technical_replicate_number");
            if (techRep == 1){
                if (bioRep == rep){
                    String uuid = replicate.getString("uuid");
                    return uuid;
                }
            }
        }
        return "";
    }
    public static void main(String[] args) throws Exception {
        
        String uuid = LibraryID.getUUID("robert-waterston:experiment_VC2396_50_1",1);
    }
}
