/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.RNASeq;

import java.io.BufferedReader;
import java.io.StringReader;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonReader;
import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.TextCell;
import org.rhwlab.db.MySql;
import org.rhwlab.spreadsheet.CellBase;

/**
 *
 * @author gevirl
 */
public class ExpressionID extends TextCell {
    public ExpressionID(){
        super();
        inputs.put("LibraryID",null);
        inputs.put("AlignmentIDs",null);
    }
    public void stateChanged(ChangeEvent event){
        String unique = ((CellBase)event.getSource()).getValueAsString();
        String library = inputs.get("LibraryID").getValueAsString();
        if (library.equals(""))return;

        this.setValue(String.format("Exp_%s_%s",library,unique));
    } 
    // find all the sequencing ids associated with an expression calculation
    static public Set<String> getSequencingIDs(String expID)throws Exception{
        TreeSet<String> ret = new TreeSet<>();
        String[] alignIDs = getAlignmentIDs(expID);
        for (String alignID : alignIDs){
            ret.add(AlignmentID.getSequencingID(alignID));
        }
        return ret;
    }
    static public int getAlignedReads(String expID)throws Exception {
        String[] alignIDs = ExpressionID.getAlignmentIDs(expID);
        int ret = 0;
        for (String AlignID : alignIDs){
            ret = ret + AlignmentID.alignedReads(AlignID);
        }
        return ret;
    }
    static public String[] getAlignmentIDs(String expId)throws Exception{
        String sql = String.format("Select * from RNAExpression where ExpressionID=\'%s\'",expId);
        ResultSet rs = MySql.getMySql().execute(sql);
        if(rs.next()){
            String alignIDs = rs.getString("AlignIDs");
            StringReader reader = new StringReader(alignIDs);
            JsonReader jsonReader = Json.createReader(reader);
            JsonArray jsonArray = jsonReader.readArray();
            String[] ret = new String[jsonArray.size()];
            for (int i=0 ; i<ret.length ; ++i){
                ret[i] = jsonArray.getString(i);
            }
            return ret;
        }
        return null;
    }

    static public boolean expressionCompleted(String ID)throws Exception {
        String sql = String.format("Select ExpressionCompleted from RNAExpression where ExpressionID=\'%s\'",ID);
        ResultSet rs = MySql.getMySql().execute(sql);
        if (rs.next()){
            return rs.getDate("ExpressionCompleted")!=null;
        } else {
            return false;
        }        
    }
    
    static public String expressionFile(String ID,FeatureGroup feature)throws Exception {
        String sql = String.format("Select Directory,ExpressionBy from RNAExpression where ExpressionID=\'%s\'",ID);
        ResultSet rs = MySql.getMySql().execute(sql);
        if (rs.next()){
            String dir = rs.getString("Directory");
            String by = rs.getString("ExpressionBy");
            if (by.contains("BitSeq")){
                return String.format("%s/%s",dir,feature.BitSeqFile(ID));
            }
        } else {
            return null;
        } 
        return null;
    }    
    static public String expressionFile(String ID)throws Exception {
        String sql = String.format("Select Directory,ExpressionBy from RNAExpression where ExpressionID=\'%s\'",ID);
        ResultSet rs = MySql.getMySql().execute(sql);
        if (rs.next()){
            String dir = rs.getString("Directory");
            String by = rs.getString("ExpressionBy");
            if (by.contains("BitSeq")){
                return String.format("%s/%s.transcript.rpkm",dir,ID);
            } else if (by.contains("HTSeq")){
                return String.format("%s/HTSeq.out.csv",dir);
            }
        } else {
            return null;
        } 
        return null;
    }
    static public String getLibraryID(String ID)throws Exception {
        String sql = String.format("Select LibraryID from RNAExpression where ExpressionID=\'%s\'",ID);
        ResultSet rs = MySql.getMySql().execute(sql);
        if (rs.next()){
            return rs.getString("LibraryID");
        } else {
            return null;
        }
    }
    static public String getReference(String ID)throws Exception {
        String sql = String.format("Select Reference from RNAExpression where ExpressionID=\'%s\'",ID);
        ResultSet rs = MySql.getMySql().execute(sql);
        if (rs.next()){
            return rs.getString("Reference");
        } else {
            return null;
        }
    }    
    static public Integer getSampleTime(String expID)throws Exception {
        String libraryID = getLibraryID(expID);
        if (libraryID == null) return null;
        
        String sampleID = LibraryID.getSampleID(libraryID);
        if (sampleID == null) return null;
        
        String stage = SampleID.getStage(sampleID);
        if (stage == null)return null;
        
        try{
            Integer ret = new Integer(stage);
            return ret;
        } catch (Exception exc){
            return null;
        }
    }

        /*
            // get all genomic alignments for this library
            sql = String.format(
                    "select * from RNASeqAlignment A join AlignmentReference R on A.Reference = R.Reference where R.SequenceType=\'Genome\' and A.LibraryID =\'%s\'",
                    libraryID);
            rs = MySql.getMySql().execute(sql);
            while (rs.next()){
                String reference = rs.getString("Reference");
                String logFile = rs.getString("LogFile");
                
                TreeMap report = readSummaryReport(id);
            }   
                
    }
    public TreeMap<String,Integer> readSummaryReport(String alignID)throws Exception {

    
                */
    
       
}
