/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.RNASeq;

import java.io.File;
import java.io.PrintWriter;
import java.util.Date;
import javax.json.JsonArray;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JOptionPane;
import org.rhwlab.LMS.ListCell;
import org.rhwlab.LMS.views.LabMan;
import org.rhwlab.spreadsheet.CellBase;

/**
 *
 * @author gevirl
 */
// RNASeq Expression calculators
public class ExpressBy extends ListCell {
    public ExpressBy(){
        
        super();
        DefaultComboBoxModel m = (DefaultComboBoxModel)this.getValue();
 //       m.addElement("PolyABitSeq1.16.0");
        m.addElement("RiboZeroBitSeq1.16.0");
//        m.addElement("BitSeq1.16.0");
        m.addElement("HTSeq-count");
        m.setSelectedItem(null);   
        
        inputs.put("Directory", null);
        inputs.put("LibraryID", null);
        inputs.put("BAMs",null);
        inputs.put("ExpressionSubmitted",null);
        inputs.put("ExpressionCompleted",null);
        inputs.put("ExpressionID",null);
        inputs.put("ExpressionBy",null);
        inputs.put("Reference", null);
        inputs.put("AlignmentIDs", null);
        inputs.put("Species",null);
    }
    public boolean isEditable(){
        CellBase submitted= inputs.get("ExpressionSubmitted");
        return submitted.getValueAsString().equals("");
    }
    public void submit()throws Exception {
        runID = inputs.get("ExpressionID").getValueAsString();

        expDir = new File(inputs.get("Directory").getValueAsString());
        // empty the directory
        if (expDir.exists()){
            File[] files = expDir.listFiles();
            for (File file : files){
                if (!file.isDirectory()){
                    file.delete();
                }
            }
        } else {
            expDir.mkdirs();
        }
        
        String scriptFile = null;
        if (this.getValueAsString().contains("BitSeq")){
            scriptFile = makeBitSeqScript();
        } else if (this.getValueAsString().contains("HTSeq")){
            scriptFile = makeHTSeqScript();
        }
        
        // start the expression script running 
        ProcessBuilder pb = new ProcessBuilder("ssh","grid.gs.washington.edu",scriptFile);
        Process p = pb.start();  

        inputs.get("ExpressionSubmitted").setValue(new Date());
        inputs.get("ExpressionCompleted").setValue(null);

    }

    private String makeHTSeqScript()throws Exception {
        File scriptFile = GridSubmitOld.scriptFile(this.runID,"HTSeq","Express");
        File qsubFile = GridSubmitOld.qsubFile(this.runID,"HTSeq");
        
         // build the script file for this expression run 
        PrintWriter writer = new PrintWriter(scriptFile);
        writer.println("#! /bin/bash");   
        writer.printf("qsub -e %s -o %s %s\n", expDir.getPath(),expDir.getPath(),qsubFile.getPath());
        writer.close();
        scriptFile.setReadable(true,false);
        scriptFile.setExecutable(true, false);
        scriptFile.setWritable(true, false);     
        
        // build the qsub file
        writer = new PrintWriter(qsubFile);
        writer.println("#$ -S /bin/bash");
        writer.println("#$ -l mfree=8G");
        writer.println("date"); 
        writer.printf("cd %s\n",expDir.getPath());
        
        writer.println("echo \"Starting HTSeq\""); 
        writer.println("module load python/2.7.3 six/1.10.0 numpy/1.8.1 matplotlib/1.3.1 HTSeq/0.6.1p1 pysam/0.8.4 ");
        writer.println("module load samtools/latest");
        writer.println("module load java/8u25"); 
        
        // build the bam file
        String[] alignIDs = ((AlignmentIDs)inputs.get("AlignmentIDs")).getIDs();
        String[] sourceBams = new String[alignIDs.length];
        for (int i=0 ; i<sourceBams.length ; ++i){
            String alignDir = AlignmentID.getDirectory(alignIDs[i]);
            sourceBams[i] = new File(alignDir,"Aligned.sortedByCoord.out.bam").getPath();
        }  
        
        String species = "CElegans";
        if (inputs.get("Species")!= null){
            species = inputs.get("Species").getValueAsString();
        }
        File bamFile = copyBAMFiles(species,sourceBams,writer);   
        AlignmentReference reference = (AlignmentReference)inputs.get("Reference");
        String stranded = "no";
        if (reference.getSpecies().equals("Dmel")){
            stranded = "yes";
        }
//        writer.printf("python /net/waterston/vol9/HTSeq-0.6.1/scripts/htseq-count -s %s -f bam -r pos -s no -t gene -i sequence_name %s %s > HTSeq.out \n",stranded,bamFile.getPath(),reference.getGFF());
        writer.printf("python /net/waterston/vol9/HTSeq-0.6.1/scripts/htseq-count -s %s -f bam -s no -t gene -i Name %s %s > HTSeq.out \n",stranded,bamFile.getPath(),reference.getGFF());
        writer.printf("rm -f %s\n", bamFile.getPath());
        writer.println("date");
        writer.println("echo \"Starting RNASeqFinisher\"");
        writer.printf("java  -jar -Xms2G /nfs/waterston/tools3/RNASeqFinisher.jar %s HTSeq \n",runID);        
        writer.close();
        
        return scriptFile.getPath();
    }
    private String makeBitSeqScript()throws Exception {
        File scriptFile = GridSubmitOld.scriptFile(this.runID,"BitSeq","Express");
        File qsubFile = GridSubmitOld.qsubFile(this.runID,"BitSeq");
        File rFile = new File(expDir,"BitSeq.R");
        rFile.setReadable(true,false);
        rFile.setExecutable(true, false);
        rFile.setWritable(true, false);         
       
         // build the script file for this expression run 
        PrintWriter writer = new PrintWriter(scriptFile);
        writer.println("#! /bin/bash");  


        writer.printf("qsub -e %s -o %s %s\n", expDir.getPath(),expDir.getPath(),qsubFile.getPath());
        writer.close();
        scriptFile.setReadable(true,false);
        scriptFile.setExecutable(true, false);
        scriptFile.setWritable(true, false);     
        
        // build the qsub file
        writer = new PrintWriter(qsubFile);
        writer.println("#$ -S /bin/bash");
        writer.println("#$ -l mfree=16G");
        writer.println("date"); 
        writer.printf("cd %s\n",expDir.getPath());
        
        
        writer.println("echo \"Starting BitSeq\""); 
        writer.println("module load hdf5/1.8.13");
        writer.println("module load netcdf/4.3.2");
        writer.println("module load R/3.1.0");
        writer.println("module load samtools/latest");
        writer.println("module load java/8u25");
        
        AlignmentReference reference = (AlignmentReference)inputs.get("Reference");        
        
        // build the bam file
        String[] alignIDs = ((AlignmentIDs)inputs.get("AlignmentIDs")).getIDs();
        String[] sourceBams = new String[alignIDs.length];
        for (int i=0 ; i<sourceBams.length ; ++i){
            String alignDir = AlignmentID.getDirectory(alignIDs[i]);
            if (reference.getType().equals("Genome")){
                sourceBams[i] = new File(alignDir,"Aligned.toTranscriptome.out.bam").getPath();
            } else {
                 sourceBams[i] = new File(alignDir,"Aligned.out.bam").getPath();
            }
        }
        
 //       writer.printf("rm -f %s\n", bamFile.getPath());
        writer.println("date");
        String species = "CElegans";
        if (inputs.get("Species")!= null){
            species = inputs.get("Species").getValueAsString();
        }        
        File bamFile = copyBAMFiles(species,sourceBams,writer);
        writer.println("R -f BitSeq.R");
        writer.println("echo \"Starting RNASeqFinisher\"");
        writer.printf("java  -jar -Xms2G /nfs/waterston/tools3/RNASeqFinisher.jar %s BitSeq \n",runID); 
//        writer.printf("chown -R :waterstonlab %s\n",expDir.getPath());
//        writer.printf("chmod -R 664 %s\n",expDir.getPath());
        writer.close();
        
        // build the R file
        writer = new PrintWriter(rFile);
        writer.println(".libPaths()");
        writer.println(".libPaths(\"/net/waterston/vol9/R_Packages/3.1\")");
        writer.println("library(BitSeq)");
        writer.printf("parseAlignment(\"%s\" ,",bamFile.getPath());
        writer.printf("outFile = \"%s.prob\" ,\n",this.runID);
       
        if (reference.getType().equals("Genome")){

            writer.println("trSeqFile = \"/net/waterston/vol9/References/WS245/WS245Test.fasta\", ");
        } else {
            writer.printf("trSeqFile = \"%s\", \n",reference.getSequenceFile());            
        }
        writer.println("trInfoFile = \"data.tr\", ");
//        writer.println("lenMu = 4.7 , ");
//        writer.println("lenSigma = 5.0e-05 , ");
        writer.println("uniform = TRUE, ");
        writer.println("verbose = TRUE, ");
        writer.println("veryVerbose = TRUE )");
        
        writer.printf("estimateExpression(\"%s.prob\" , outFile = \"%s\" , \n",runID,runID);
        writer.println("outputType = \"RPKM\" , trInfoFile = \"data.tr\" ,");
        writer.println("MCMC_burnIn = 1000 , MCMC_samplesN = 1000 , MCMC_samplesSave = 1000 , MCMC_chainsN = 2)");
        writer.close();
        
        return scriptFile.getPath();
    }
    // aggregate the bam files that are to be combined and remove any reads that should be filtered
    private File copyBAMFiles(String species,String[] sourceBams,PrintWriter writer){
        boolean ribo = this.getValueAsString().startsWith("RiboZero");
        boolean polyA = this.getValueAsString().startsWith("PolyA");
        String ribosomal = Boolean.toString(ribo||polyA);
        String histone = Boolean.toString(polyA);
        
        String library = inputs.get("LibraryID").getValueAsString();
        File mergedFile = new File(expDir,String.format("%s.bam", library));
        writer.printf("java -classpath /nfs/waterston/tools3/LabManagement.jar org.rhwlab.LMS.RNASeq.Bams %s %s %s %s",histone,ribosomal,mergedFile,species);      
        
        for (String sourceBam : sourceBams){
            writer.printf(" %s", sourceBam);
        }
        writer.println();
        return mergedFile;
    }
    
    String runID;
    File expDir; 
//    static HashMap<String,String> seqFileMap;

    @Override
    public boolean validate(String newValue) {
        return true;
/*        
        try {
            boolean ret = this.model.isRowUnique(this.getRow());
            if (ret == true) return true;
            String msg = String.format("%s already in database\nWill revert to previous value",this.getValueAsString());
            JOptionPane.showMessageDialog(LabMan.labMan, msg);
            return false;
        } catch (Exception exc){
            exc.printStackTrace();
            return true;
        }
*/

    }
}
