/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.RNASeq;

import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import org.rhwlab.LMS.DCCResponse;
import org.rhwlab.encode.FileUploadUrl;
import org.rhwlab.json.PrettyWriter;

/**
 *
 * @author gevirl
 */
public class DCCFileResponse extends DCCResponse {
    
    // extracts the value of the given credential from the returned DCC json
    static public String getUploadCredential(String credentialName,JsonObject obj){
        JsonArray graphArray = obj.getJsonArray("@graph");
        JsonObject respObject = graphArray.getJsonObject(0);
        JsonObject credObj = respObject.getJsonObject("upload_credentials");
        return credObj.getString(credentialName);
    }
    public String getUploadFilepath(String accession){
        JsonObject accObj = this.getJsonForAccession(accession);
        return accObj.getString("submitted_file_name");
    } 
    
    // gets the current upload credentials for a file
    // will request new credentials if they are expired
    public JsonObject getUploadCredentials(String server,String accession)throws Exception {
        JsonObject emptyObject = Json.createObjectBuilder().build();
        
        FileUploadUrl url = new FileUploadUrl(server,accession);
        
        // get the exisiting credentials
        String  credentials = url.postJson(emptyObject);
        PrettyWriter pretty = new PrettyWriter();
        pretty.write(credentials);
        return pretty.getJson();
        
    }
}
