/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.RNASeq;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.swing.DefaultComboBoxModel;
import org.rhwlab.LMS.ListCell;
import org.rhwlab.spreadsheet.CellBase;

/**
 *
 * @author gevirl
 */
public class AnalysisBy extends ListCell {
    public AnalysisBy(){
        super();
        DefaultComboBoxModel m = (DefaultComboBoxModel)this.getValue();
        m.addElement("BitSeq");
        m.addElement("Monocle");
        m.setSelectedItem(null); 
        
        inputs.put("Directory", null);
        inputs.put("AnalysisID", null);
        inputs.put("Conditions",null);  
        inputs.put("Features",null); 
        inputs.put("Submitted",null);
        inputs.put("Completed",null);        
    }
    public boolean isEditable(){
        CellBase submitted= inputs.get("Submitted");
        return submitted.getValueAsString().equals("");
    }    
    public void submit()throws Exception {
        analysisID = inputs.get("AnalysisID").getValueAsString();

        analysisDir = new File(inputs.get("Directory").getValueAsString());
        analysisDir.mkdirs();
        
        String scriptFile = null;
        if (this.getValueAsString().contains("BitSeq")){
            scriptFile = makeBitSeqScript();
        } else {
            scriptFile = makeMonocleScript();
            makeMonocleFiles();
        }
        
        // start the expression script running 
        ProcessBuilder pb = new ProcessBuilder("ssh","grid.gs.washington.edu",scriptFile);
        Process p = pb.start();  

        inputs.get("Submitted").setValue(new Date());
        inputs.get("Completed").setValue(null);
    }

    private void makeMonocleFiles()throws Exception {
        File outFile = new File(inputs.get("Directory").getValueAsString(),"DataMatrix.tab");
        PrintWriter writer = new PrintWriter(outFile);
//        writer.print("tracking_id");
        
        File featureFile = new File(inputs.get("Directory").getValueAsString(),"FeatureAnnotations.tab");
        PrintWriter featureWriter = new PrintWriter(featureFile);
        featureWriter.print("gene_id\tgene_type\n");
        
        File sampleFile = new File(inputs.get("Directory").getValueAsString(),"SampleMetaData.tab");
        PrintWriter sampleWriter = new PrintWriter(sampleFile);
        sampleWriter.print("condition_id\n");        
        
        // open all the input files
        ArrayList<BufferedReader> readers = new ArrayList<>();      
        AnalysisConditions conds = (AnalysisConditions)inputs.get("Conditions");
        String[] condIDs = conds.getConditionIDs();
        boolean first = true;
        for (String condID : condIDs){
            String[] expIDs = conds.getReplicateIDs(condID);
            
            for (String expID : expIDs){
                if (first){
                    writer.printf("%s", expID);
                    first = false;
                }else {
                    writer.printf("\t%s", expID);
                }
                FeatureGroup group = (FeatureGroup)((Features)inputs.get("Features")).getSelectedValue();
                String infile = ExpressionID.expressionFile(expID, group);
                BufferedReader reader = new BufferedReader(new FileReader(infile));
                readers.add(reader);
                
                sampleWriter.printf("%s\t%s\n",expID,condID);
            }
        }
        writer.println();
        
        // read all the data and write the data matrix file
        String[] lines = new String[readers.size()];
        for (int i=0 ; i<readers.size() ; ++i){
            lines[i] = readers.get(i).readLine();
        }
        while(lines[0] != null) {
            first = true;
            
            for (String line : lines) {
                String[] tokens = line.split("\t| ");
                if (first){
                    featureWriter.printf("%s\t%s\t%s\n",tokens[0],tokens[1],tokens[2]);
                    writer.printf("%s\t%s",tokens[0],tokens[3]);
                    first = false;
                } else {
                    writer.printf("\t%s",tokens[3]);
                }
            }
            writer.println();
            
            for (int i=0 ; i<readers.size() ; ++i){
                lines[i] = readers.get(i).readLine();
            }            
        }
        
        writer.flush();
        writer.close();
        featureWriter.flush();
        featureWriter.close();
        sampleWriter.flush();
        sampleWriter.close();
    }
    private String makeMonocleScript()throws Exception {
        File scriptFile = GridSubmitOld.scriptFile(this.analysisID,"Monocle","Analysis");
        File qsubFile = GridSubmitOld.qsubFile(this.analysisID,"Analysis");
        File rFile = new File(analysisDir,"Analysis.R");
        rFile.setReadable(true,false);
        rFile.setExecutable(true, false);
        rFile.setWritable(true, false);         
       
         // build the script file for this expression run 
        PrintWriter writer = new PrintWriter(scriptFile);
        writer.println("#! /bin/bash");  
      
        writer.printf("qsub -e %s -o %s %s\n", analysisDir.getPath(),analysisDir.getPath(),qsubFile.getPath());
        writer.close();
        scriptFile.setReadable(true,false);
        scriptFile.setExecutable(true, false);
        scriptFile.setWritable(true, false);     
        
        // build the qsub file
        writer = new PrintWriter(qsubFile);
        writer.println("#$ -S /bin/bash");
        writer.println("#$ -l mfree=16G");
        writer.println("date"); 
        writer.printf("cd %s\n",analysisDir.getPath());
        writer.println("echo \"Starting Monocle Analysis\"");
        writer.println("module load R/3.2.1");
        writer.println("module load java/8u25");
//        writer.println("module load R/3.1.0");
        writer.println("R -f Analysis.R");
 //       writer.println("/net/waterston/vol9/R-3.2.2/bin/R -f Analysis.R");
        
        writer.printf("chown -R :waterstonlab %s\n",analysisDir.getPath());
        writer.println("date");
        writer.println("echo \"Starting RNASeqFinisher\"");
        writer.printf("java  -jar -Xms2G /nfs/waterston/tools3/RNASeqFinisher.jar %s Monocle \n",analysisID);
        writer.printf("chown -R :waterstonlab %s\n",analysisDir.getPath());
        writer.close();      
        
        // build the R file
        writer = new PrintWriter(rFile);
        writer.println(".libPaths(\"/net/waterston/vol9/R_Library\")");
        writer.println("library(Biobase)");
        writer.println("library(monocle)");
        writer.println("expr_matrix <- read.delim(\"DataMatrix.tab\",sep=\"\\t\",header=TRUE)");
        writer.println("feature_annotation <- read.delim(\"FeatureAnnotations.tab\",sep=\"\\t\",header=TRUE)");
        writer.println("sample_metadata <- read.delim(\"SampleMetaData.tab\",sep=\"\\t\",header=TRUE)");
        writer.println("pd <- new(\"AnnotatedDataFrame\",data = sample_metadata)");
        writer.println("fd <- new(\"AnnotatedDataFrame\",data = feature_annotation)");
        
        writer.println("pd");
        writer.println("fd");
//        writer.println("expr_matrix");
        
        writer.println("expr <- newCellDataSet(as.matrix(expr_matrix),phenoData=pd,featureData=fd)");
        writer.println("diffTestRes <- differentialGeneTest(expr,fullModelFormulaStr=\"expression~condition_id\")");
        writer.close();
        
        return scriptFile.getPath();
    }
    private String makeBitSeqScript()throws Exception {
        File scriptFile = GridSubmitOld.scriptFile(this.analysisID,"BitSeq","Analysis");
        File qsubFile = GridSubmitOld.qsubFile(this.analysisID,"Analysis");
        File rFile = new File(analysisDir,"Analysis.R");
        rFile.setReadable(true,false);
        rFile.setExecutable(true, false);
        rFile.setWritable(true, false);         
       
         // build the script file for this expression run 
        PrintWriter writer = new PrintWriter(scriptFile);
        writer.println("#! /bin/bash");  
      
        writer.printf("qsub -e %s -o %s %s\n", analysisDir.getPath(),analysisDir.getPath(),qsubFile.getPath());
        writer.close();
        scriptFile.setReadable(true,false);
        scriptFile.setExecutable(true, false);
        scriptFile.setWritable(true, false);     
        
        // build the qsub file
        writer = new PrintWriter(qsubFile);
        writer.println("#$ -S /bin/bash");
        writer.println("#$ -l mfree=16G");
        writer.println("date"); 
        writer.printf("cd %s\n",analysisDir.getPath());
        writer.println("echo \"Starting BitSeq Analysis\""); 
        writer.println("module load hdf5/1.8.13");
        writer.println("module load netcdf/4.3.2");
        writer.println("module load R/3.1.0");
        writer.println("module load java/8u25");
        writer.println("R -f Analysis.R");
//        writer.printf("chown -R :waterstonlab %s\n",analysisDir.getPath());
        writer.println("date");
        writer.println("echo \"Starting RNASeqFinisher\"");
        writer.printf("java  -jar -Xms2G /nfs/waterston/tools3/RNASeqFinisher.jar %s Analysis \n",analysisID);

        writer.close();
        
        // build the R file
        AnalysisConditions conds = ((AnalysisConditions)inputs.get("Conditions"));
        StringBuilder builder = new StringBuilder();
        builder.append("allConditions = list(");
        boolean firstCond = true;
        for (String condID : conds.getConditionIDs()){
            if (!firstCond){
                builder.append(",");
            }
            firstCond = false;
            builder.append("c(");
            String[] replicates = conds.getReplicateIDs(condID);
            boolean firstReplicate = true;
            for (String runID : replicates){
                String dir = org.rhwlab.LMS.RNASeq.merged.ExpressionID.getDirectory(runID);
                if (!firstReplicate){
                    builder.append(",");
                }
                builder.append("\"");
                builder.append(dir);
                builder.append("/");
                builder.append(runID);
                builder.append(".rpkm\"");
                firstReplicate = false;
            }
            builder.append(")");
            
        }
        builder.append(")");
        
        writer = new PrintWriter(rFile);
        writer.println(".libPaths(\"/net/waterston/vol9/R_Packages/3.1\")");
        writer.println("library(BitSeq)");
        writer.println(builder.toString());
        writer.println("getMeanVariance(allConditions,outFile=\"data.means\",log=TRUE)");
        writer.println("estimateHyperPar(outFile=\"data.par\",conditions=allConditions,meanFile=\"data.means\",verbose=TRUE,force=TRUE)");
        writer.println("estimateDE(allConditions,outFile=\"data\",parFile=\"data.par\")");
        

        writer.close();
        
        return scriptFile.getPath();
    }    
    @Override
    public boolean validate(String newValue) {
        return true;
    }
    String analysisID;
    File analysisDir;    
}
