/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.RNASeq;

import java.util.ArrayList;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.JsonCell;

/**
 *
 * @author gevirl
 */
public class AlignmentIDs extends JsonCell{
    public AlignmentIDs(){
        inputs.put("Reference",null);
    }
    public String[] getIDs(){
        if (this.getValue() instanceof JsonArray){
            JsonArray jsonArray = (JsonArray)this.getValue();
            String[] ret = new String[jsonArray.size()];
            for (int i=0 ; i<ret.length ; ++i){
                ret[i] = jsonArray.getString(i);
            }
            return ret;
        } else {
            String[] ret = new String[1];
            ret[0] = this.getValueAsString();
            return ret;
        }        
    }
    public List<String> getSequenceIds(){
        ArrayList<String> ret = new ArrayList<>();
        String[] seqIDs = this.getIDs();
        for (int i=0 ; i< seqIDs.length ; ++i){
            // remove the reference
            int first = seqIDs[i].indexOf("_");
            int second = seqIDs[i].indexOf("_", first+1);
            ret.add(seqIDs[i].substring(second+1));
        }
        return ret;
    }
    public void stateChanged(ChangeEvent event){
        String ref = inputs.get("Reference").getValueAsString();

        String[] ids = this.getIDs();
        if (ids[0].equals("")) return;
        // gather all the AlignmentIDs into a json array
        JsonArrayBuilder alignBuilder = Json.createArrayBuilder();
        for (int i=0 ; i<ids.length ;++i){
            String id = ref + ids[i].substring(ids[i].indexOf('_'));
            try {
                if (!AlignmentID.finishedAligning(id)){
                    JOptionPane.showMessageDialog(panel,"Alignments have not been completed");
                    inputs.get("Reference").setValue("",false);
                    return;
                }
            } catch(Exception exc){
                exc.printStackTrace();
            }
            alignBuilder.add(id) ;
        } 
        this.setValue(alignBuilder.build(), true);
    }    
}
