/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.RNASeq;

import java.io.File;
import java.io.PrintWriter;
import java.util.List;
import java.util.TreeMap;
import javax.json.JsonObject;

/**
 *
 * @author gevirl
 */
public class AWS extends DCCFileResponse {
    public AWS(){
        if (credMap == null){
            credMap = new TreeMap<>();
            credMap.put("AWS_ACCESS_KEY_ID","access_key");
            credMap.put("AWS_SECRET_ACCESS_KEY","secret_key");
            credMap.put("AWS_SECURITY_TOKEN","session_token");
        }
        inputs.put("SequencingID",null);
        inputs.put("Directory",null);
        inputs.put("DCCResponse",null);
        inputs.put("AlignmentID",null);
        inputs.put("ExpressionID",null);
    }
    public void submit(String server)throws Exception {
        this.server = server;
        String scriptFile = makeSeqFilesScript();
        // start the alignment script running 
        ProcessBuilder pb = new ProcessBuilder("ssh","grid.gs.washington.edu",scriptFile);
        Process p = pb.start();         
    }
    public void submitAlignment(String server)throws Exception {
        this.server = server;
        String scriptFile = makeAlignFilesScript();
        // start the alignment script running 
        ProcessBuilder pb = new ProcessBuilder("ssh","grid.gs.washington.edu",scriptFile);
        Process p = pb.start();         
    }    
    public void submitExpression(String server)throws Exception {
        this.server = server;
        String scriptFile = makeExpressionFilesScript();
        // start the alignment script running 
        ProcessBuilder pb = new ProcessBuilder("ssh","grid.gs.washington.edu",scriptFile);
        Process p = pb.start();         
    }     
    private String makeSeqFilesScript()throws Exception{
        DCCFileResponse dccResponse = (DCCFileResponse)inputs.get("DCCResponse");
        this.runID = inputs.get("SequencingID").getValueAsString();
        this.alignDir = new File(inputs.get("Directory").getValueAsString());
        
        File scriptFile = GridSubmitOld.scriptFile(this.runID,"AWS","Sequencing");
        File qsubFile = GridSubmitOld.qsubFile(this.runID,"AWS");
        
         // build the script file for this sequencing updload
        PrintWriter writer = new PrintWriter(scriptFile);
        writer.println("#! /bin/bash"); 
        writer.printf("qsub -e %s -o %s %s\n", alignDir.getPath(),alignDir.getPath(),qsubFile.getPath());
        writer.close();
        scriptFile.setReadable(true,false);
        scriptFile.setExecutable(true, false);
        scriptFile.setWritable(true, false);          
        
        writer = new PrintWriter(qsubFile);
        writer.println("#$ -S /bin/bash");
        writer.println("#$ -l mfree=1G");  
        writer.println("#$ -l h_rt=96:0:0");
        writer.println("date"); 
        writer.println("echo \"Starting aws\"");  
        writer.println("module load python/3.3.3");
        List<String> accessions = this.getAccessions("file");
        for (String accession : accessions){
            JsonObject cred = dccResponse.getUploadCredentials(server, accession);
            for (String key : credMap.keySet()){
        
 //               writer.printf("export %s=%s\n",key,DCCFileResponse.getUploadCredential(credMap.get(key),cred));
                String export = String.format("export %s=%s\n",key,DCCFileResponse.getUploadCredential(credMap.get(key),cred));
                writer.print(export);
            }
            String path = this.getUploadFilepath(accession);
            String uploadURL = DCCFileResponse.getUploadCredential("upload_url",cred);
            writer.printf("%s s3 cp %s %s\n",awsProgram, path,uploadURL);
        }
        writer.flush();
        writer.close();
        return scriptFile.getPath();
    }    
    private String makeAlignFilesScript()throws Exception{
        DCCFileResponse dccResponse = (DCCFileResponse)inputs.get("DCCResponse");
        this.runID = inputs.get("AlignmentID").getValueAsString();
        this.alignDir = new File(inputs.get("Directory").getValueAsString());
        
        File scriptFile = GridSubmitOld.scriptFile(this.runID,"AWS","Alignment");
        File qsubFile = GridSubmitOld.qsubFile(this.runID,"AWS");
        
         // build the script file for this sequencing updload
        PrintWriter writer = new PrintWriter(scriptFile);
        writer.println("#! /bin/bash"); 
        writer.printf("qsub -e %s -o %s %s\n", alignDir.getPath(),alignDir.getPath(),qsubFile.getPath());
        writer.close();
        scriptFile.setReadable(true,false);
        scriptFile.setExecutable(true, false);
        scriptFile.setWritable(true, false);          
        
        writer = new PrintWriter(qsubFile);
        writer.println("#$ -S /bin/bash");
        writer.println("#$ -l mfree=1G"); 
        writer.println("#$ -l h_rt=96:0:0");
        writer.println("date"); 
        writer.println("echo \"Starting aws\"");  
        writer.println("module load python/3.3.3");
        List<String> accessions = this.getAccessions("file");
        for (String accession : accessions){
            JsonObject cred = dccResponse.getUploadCredentials(server, accession);
            for (String key : credMap.keySet()){
        
 //               writer.printf("export %s=%s\n",key,DCCFileResponse.getUploadCredential(credMap.get(key),cred));
                String export = String.format("export %s=%s\n",key,DCCFileResponse.getUploadCredential(credMap.get(key),cred));
                writer.print(export);
            }
            String path = this.getUploadFilepath(accession);
            String uploadURL = DCCFileResponse.getUploadCredential("upload_url",cred);
            writer.printf("%s s3 cp %s %s\n",awsProgram, path,uploadURL);
        }
        writer.flush();
        writer.close();
        return scriptFile.getPath();
    }
    private String makeExpressionFilesScript()throws Exception{
        DCCFileResponse dccResponse = (DCCFileResponse)inputs.get("DCCResponse");
        this.runID = inputs.get("ExpressionID").getValueAsString();
        this.alignDir = new File(inputs.get("Directory").getValueAsString());
        
        File scriptFile = GridSubmitOld.scriptFile(this.runID,"AWS","Expression");
        File qsubFile = GridSubmitOld.qsubFile(this.runID,"AWS");
        
         // build the script file for this sequencing updload
        PrintWriter writer = new PrintWriter(scriptFile);
        writer.println("#! /bin/bash"); 
        writer.printf("qsub -e %s -o %s %s\n", alignDir.getPath(),alignDir.getPath(),qsubFile.getPath());
        writer.close();
        scriptFile.setReadable(true,false);
        scriptFile.setExecutable(true, false);
        scriptFile.setWritable(true, false);          
        
        writer = new PrintWriter(qsubFile);
        writer.println("#$ -S /bin/bash");
        writer.println("#$ -l mfree=1G");  
        writer.println("#$ -l h_rt=96:0:0");
        writer.println("date"); 
        writer.println("echo \"Starting aws\"");  
        writer.println("module load python/3.3.3");
        List<String> accessions = this.getAccessions("file");
        for (String accession : accessions){
            JsonObject cred = dccResponse.getUploadCredentials(server, accession);
            for (String key : credMap.keySet()){
        
 //               writer.printf("export %s=%s\n",key,DCCFileResponse.getUploadCredential(credMap.get(key),cred));
                String export = String.format("export %s=%s\n",key,DCCFileResponse.getUploadCredential(credMap.get(key),cred));
                writer.print(export);
            }
            String path = this.getUploadFilepath(accession);
            String uploadURL = DCCFileResponse.getUploadCredential("upload_url",cred);
            writer.printf("%s s3 cp %s %s\n",awsProgram, path,uploadURL);
        }
        writer.flush();
        writer.close();
        return scriptFile.getPath();
    }    
    String server;
    TreeMap<String,String> credMap = null;
    static String awsProgram = "/net/waterston/vol9/aws/bin/aws";
    String runID;
    File alignDir;
}
