/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import javax.json.stream.JsonParser;

/**
 *
 * @author gevirl
 */
public class JsonCell extends TextCell{
    public boolean setValue(Object obj){
        return this.setValue(obj,true);
    }
    public boolean setValue(Object obj,boolean notify){
        if (obj instanceof String){
            String in = (String)obj;
            if (!in.startsWith("[") && !in.startsWith("{")){
                in = String.format("[\"%s\"]",in);
            }
            StringReader reader = new StringReader(in);
            JsonReader jsonReader = Json.createReader(reader);
            return super.setValue(jsonReader.read(),notify);
        }
        return super.setValue(obj, notify);
    }
    public String getValueAsString(){
        if (this.value instanceof String){
            return (String)this.getValue();
        }
        else if (this.value instanceof JsonStructure){
            JsonStructure jsonStruct = (JsonStructure)this.getValue();
            return jsonStruct.toString();
        }
        return "";
    }
    public static List<JsonStructure> toJson(String in)throws Exception {
        ArrayList<JsonStructure> ret = new ArrayList<>();
        BufferedReader bufReader = new BufferedReader(new StringReader(in));
        String line = bufReader.readLine();
        while (line != null){
            StringReader reader = new StringReader(line);
            JsonReader jsonReader = Json.createReader(reader);
            ret.add(jsonReader.read());
            line = bufReader.readLine();
        }
        return ret;
    }
}
