/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS;

import org.rhwlab.spreadsheet.CellBase;

/**
 *
 * @author gevirl
 */
public class IntegerCell extends TextCell {
    public IntegerCell(){
        super("");
    }
    public IntegerCell(String i){
        super(i);
    }
    public void setParameter(String name,String value){
        if (name.equals("minimum")){
            min = Integer.parseInt(value);
        } else if (name.equals("maximum")){
            max = Integer.parseInt(value);
        }
    }

    @Override
    public boolean validate(String newValue) {
        if (!validate) return true;
        if (newValue.equals("")) return true;
        try {
            int v = Integer.parseInt(newValue);
            if (v < min || v > max) return false;
        } catch (Exception exc){
            return false;
        }
        return true;
    } 
    public Integer getValueAsInteger(){
        if (this.value instanceof String){
            String vStr = (String)value;
            if (vStr.equals("")) return null;
            return Integer.valueOf(vStr);
        }
        return (Integer)value;
    }
    @Override
    public int compareTo(Object o) {
        IntegerCell other = (IntegerCell)o;
        Integer v1 = this.getValueAsInteger();
        Integer  v2 = other.getValueAsInteger();
        if (v1 != null && v2 !=null) {
            return v1.compareTo(v2);
        } 
        if (v1 ==null && v2 == null){
            return 0;
        } else if (v1 ==null){
            return -1;
        }
        
        return 1;
    }   
    public String getValueAsString(){
        String v = super.getValueAsString();
        if (v.equals("")) return v;
        try {
            return Integer.toString(Integer.parseInt(v));
        } catch (Exception exc){
            int isudbf=0;
        }
        return "";
        
    }
    int min=Integer.MIN_VALUE;
    int max=Integer.MAX_VALUE;

}
