/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS;

import java.sql.ResultSet;
import org.rhwlab.LMS.prep.DNAID;
import javax.swing.event.ChangeEvent;
import org.rhwlab.LMS.cross.OffSpringStrain;
import org.rhwlab.LMS.rescue.RescueID;
import org.rhwlab.LMS.strain.ConstructID;
import org.rhwlab.LMS.strain.ReporterConstruct;
import org.rhwlab.LMS.strain.Strain;
import org.rhwlab.db.MySql;
import org.rhwlab.db.beans.Gene;
import org.rhwlab.spreadsheet.CellBase;

/**
 *
 * @author gevirl
 */
public class GeneName extends TextCell {
    public GeneName(){
        super("");
    }
    public boolean setValue(Object obj){
        return this.setValue(obj, true);
    }
    public String getSequenceName()throws Exception {
        String curValue = this.getValueAsString();
        String sql = String.format("Select * from Gene where CGC = \'%s\'",curValue);
        ResultSet rs = MySql.getMySql().execute(sql);
        if (rs.next()){    
            curValue = rs.getString("Sequence");
        } 
        return curValue;
    }
    public boolean setValue(Object obj,boolean notify){
        if (this.model == null) return super.setValue(obj, notify);
        if (this.getModel().isLoading()) return super.setValue(obj, notify);
        
        String newValue = (String)obj;
        // is it a sequence name??
        try {        
            String sql = String.format("Select * from Gene where Sequence = \'%s\'",newValue);
            ResultSet rs = MySql.getMySql().execute(sql);
            if (rs.next()){
                String cgc = rs.getString("CGC");
                if (cgc != null && !cgc.equals("")){
                    newValue = cgc;
                }
            } 
            return super.setValue(newValue, notify);
        }catch(Exception exc){
            exc.printStackTrace();
            return false;
        }

    }
    public boolean validate(String newValue)  {
        if (!validate) return true;
        if (newValue.equals("")) return true;
        // is it a valid sequence name
        try{
            // check the database for valid Sequence name
            String sql = String.format("Select * from Gene where Sequence=\'%s\'",newValue);
            ResultSet rs = MySql.getMySql().execute(sql);
            if (rs.next()){
                return true;
            }
            sql = String.format("Select * from Gene where CGC=\'%s\'",newValue);
            rs = MySql.getMySql().execute(sql);
            if (rs.next()){
                return true;
            }            
        } catch(Exception exc){
            exc.printStackTrace();
        }
        return false;
    }
    public void stateChanged(ChangeEvent event){
        if (locked) return;
        
        Object source = event.getSource();
        String newValue = ((CellBase)source).getValueAsString();
        if (newValue.equals(""))return;
        String current = this.getValueAsString();
        if (!current.equals(""))return;
        try {
            String name = null;
            Gene gene = new Gene();
            if (source instanceof Sequence){
                gene.fromMySqlBySequence(MySql.getMySql(), newValue);
                name = gene.getName();
            } else if (source instanceof Transcript || source instanceof org.rhwlab.LMS.stock.Transcript) {
                gene.fromTranscript(MySql.getMySql(), newValue);
                name = gene.getName();
            } else if (source instanceof DNAID){
                name = ((DNAID)source).getGeneName();
            } else if (source instanceof RescueID){
                name = ((RescueID)source).getGeneName();
            } else if (source instanceof ReporterConstruct){
                name = ((ReporterConstruct)source).getGeneName();
            } else if (source instanceof ConstructID){
                name = ((ConstructID)source).getGeneName();
            } else if (source instanceof OffSpringStrain){
                name = ((OffSpringStrain)source).getGene();
            } else if (source instanceof Strain){
                name = ((Strain)source).getGene();
            }
            if (name != null && !name.equals("")){
                this.setValue(name);
            }
            
        } catch (Exception exc ){
            
        }
    }
}
