/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.FACS;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.List;
import java.util.TreeMap;
import org.rhwlab.alignment.BAM;

/**
 *
 * @author gevirl
 */
// args[0] file with directory names of merged bams 
public class HistoneCounts {

    static public void main(String[] args) throws Exception {
        
        PrintStream stream = new PrintStream("/net/waterston/vol2/home/gevirl/FACS/HistoneReadCounts.csv");
        
        TreeMap<String, File> fileMap = new TreeMap<>();

        File dirsFile = new File("/net/waterston/vol2/home/gevirl/FACS/AlignmentDirectories");
        BufferedReader reader = new BufferedReader(new FileReader(dirsFile));
        String line = reader.readLine();
        while (line != null) {
            File dir = new File(line);
            File file = new File(dir, "Aligned.toTranscriptome.out.bam");
            String label = dir.getParentFile().getName();
            fileMap.put(label, file);
            line = reader.readLine();
        }
        reader.close();

        TreeMap<String, int[]> countMap = new TreeMap<>();  //indexed by histone

        int i = 0;
        for (String label : fileMap.keySet()) {
            System.out.println(label);
            BAM bam = new BAM(fileMap.get(label));
            TreeMap<String, Integer> histoneCounts = bam.histoneReadCounts();
            
            for (String histone : histoneCounts.keySet()) {
                int[] counts = countMap.get(histone);
                if (counts == null) {
                    counts = new int[fileMap.size()];
                    countMap.put(histone, counts);
                }
                counts[i] = histoneCounts.get(histone);
            }
            ++i;
        }
        
        stream.print("Histone");
        for (String label : fileMap.keySet()){
            stream.printf(",%s",label);
        }
        stream.println();    
        
        for (String histone : countMap.keySet()){
            stream.print(histone);
            for (int count : countMap.get(histone)){
                stream.printf(",%d",count);
            }
            stream.println();
        }
        stream.close();
        int oaisdfis = 0;
    }
}
