/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS;

/**
 *
 * @author gevirl
 */
public class DoubleCell extends TextCell {
    public DoubleCell(){
        this("");
    }
    public DoubleCell(String i){
        super(i);
    }
    public void setParameter(String name,String value){
        if (name.equals("minimum")){
            min = Double.parseDouble(value);
        } else if (name.equals("maximum")){
            max = Double.parseDouble(value);
        }
    }
    public Double getValueAsDouble(){
        if (this.getValueAsString().equals("")) return null;
        return Double.valueOf(this.getValueAsString());
    }    
    @Override
    public int compareTo(Object o) {
        DoubleCell other = (DoubleCell)o;
        Double v1 = this.getValueAsDouble();
        Double  v2 = other.getValueAsDouble();
        if (v1 != null && v2 !=null) {
            return v1.compareTo(v2);
        } 
        if (v1 ==null && v2 == null){
            return 0;
        } else if (v1 ==null){
            return -1;
        }
        
        return 1;
    }  
    @Override
    public boolean validate(String newValue) {
        if (!validate) return true;
        if (newValue.equals("")) return true;
        try {
            double v = Double.parseDouble(newValue);
            if (v < min || v > max) return false;
        } catch (Exception exc){
            return false;
        }
        return true;
    }    
    double min=-Double.MAX_VALUE;
    double max=Double.MAX_VALUE;    
}
