/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

/**
 *
 * @author gevirl
 */
public class DateTimeStamp extends DateCell {
    public boolean setValue(Object newValue){
        if (timeformat==null){
            timeformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            timeformat.getCalendar().getTimeZone().setID("America/Los_Angeles");
        }
        return this.setValue(newValue, true);
        
    }
    public boolean setValue(Object newValue,boolean notify) {
        if (newValue == null) return super.setValue(newValue,notify);
        if (newValue instanceof String){
            Date date = DateTimeStamp.timeformat.parse((String)newValue, new ParsePosition(0));
            return super.setValue(date,notify);

        }
        return super.setValue(newValue,notify);
    }    
    @Override
    public String getValueAsString() {
        try {
            String str = timeformat.format(value);
            return str;
        } catch (Exception exc){
            return "";
        }
    }
    public String getAsSqlString(){
        return this.getValueAsString();
    }    

    public static SimpleDateFormat timeformat = null; 
    

}
