/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.event.ChangeEvent;
import org.rhwlab.spreadsheet.CellBase;

/**
 *
 * @author gevirl
 */
public class DateCell extends CellBase {

    public DateCell() {
        this(null);
    }

    public DateCell(Date date) {
        super(date);
        for (SimpleDateFormat format : formats){
            format.setLenient(true);
        }
    }

    public boolean setValue(Object newValue){
        return this.setValue(newValue, true);
    }
    public boolean setValue(Object newValue,boolean notify) {
        if (newValue == null) return super.setValue(newValue,notify);
        if (newValue instanceof String){
            Date date = tryToParse((String)newValue);
            return super.setValue(date,notify);

        }
        return super.setValue(newValue,notify);
    }

    @Override
    public boolean validate(String newValue) {
        if (!validate) return true;
        if (newValue == null) return true;
        if (newValue.equals("")) return true;
        if (tryToParse(newValue)!=null)
            return true;
        return false;
    }


    @Override
    public String getValueAsString() {
        try {
            String str = sqlFormat.format(value);
            return str;
        } catch (Exception exc){
            return "";
        }
    }
    public String getAsSqlString(){
        try {
            String str = sqlFormat.format(value);
            return str;
        } catch (Exception exc){
            return "";
        }        
    }
    private Date tryToParse(String s){
        
        Date ret = sqlFormat.parse(s, new ParsePosition(0));
        if (ret != null) return ret;
        
        for (SimpleDateFormat format : formats){
            ret = format.parse(s, new ParsePosition(0));
            if  (ret != null) return ret;
        }
        return null;
    }
    static SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MMM-yy");
    public static SimpleDateFormat sqlFormat = new SimpleDateFormat("yyyy-MM-dd");  
    static SimpleDateFormat[] formats ={
        new SimpleDateFormat("dd-MMM-yy"),
        new SimpleDateFormat("ddMMMyy"),
        new SimpleDateFormat("dd-MM-yy"),
        new SimpleDateFormat("ddMMyy"),
        new SimpleDateFormat("MM/dd/yy"),
        new SimpleDateFormat("MM/dd/yyyy")
        };

    @Override
    public int compareTo(Object o) {
        CellBase other = (CellBase)o;
        Date otherDate = (Date)other.getValue();
        
        Date cellDate = (Date)this.getValue();
        if (cellDate == null){
            if (otherDate == null){
                return 0;
            } 
            return -1;
        }

        
        if (otherDate == null){
            return 1;
        }
       
        return cellDate.compareTo((Date)other.getValue());
    }
}
