/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS;

import java.sql.ResultSet;
import javax.swing.event.ChangeEvent;
import org.rhwlab.db.MySql;
import org.rhwlab.spreadsheet.CellBase;


/**
 *
 * @author gevirl
 */
public class CGC extends TextCell {
    public CGC(){
        this("");
    }
    public CGC(String value){
        super(value);
    }

    public boolean validate(String newValue)  {
        if (!validate) return true;
        if (newValue.equals("")) return true;
        try {
            // check the database for valid CGC name
            String sql = String.format("Select * from Gene where CGC=\'%s\'",newValue);
            ResultSet rs = MySql.getMySql().execute(sql);
            if (rs.next()){
                return true;
            }
        } catch (Exception exc){ exc.printStackTrace();}
        return false;
    }   
    public void stateChanged(ChangeEvent event){
        if (locked) return;
        Object source = event.getSource();
        String newValue = ((CellBase)source).getValueAsString();
        if (newValue.equals(""))return;                
        try {
            String sql=null;
            if (source instanceof Sequence){
                sql = String.format("Select CGC from Gene where Sequence=\'%s\'",newValue);
            }else if (source instanceof Transcript){
                sql = String.format("Select G.CGC from Transcript T,Gene G where "
                        + "T.WBGene=G.WBGene and T.TranscriptName=\'%s\'"
                        ,newValue);
            } else if (source instanceof BooleanCell){
                if (newValue.equals("1")){
                    this.setEditable(false);
                }
                return;
            }
            ResultSet rs = MySql.getMySql().execute(sql);
            if (rs.next())
                this.setValue(rs.getString("CGC"));
        } catch(Exception exc){
            exc.printStackTrace();
            System.exit(0);
        }
    }     
}
