/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.wormbase;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.rhwlab.db.MySql;
import org.rhwlab.db.beans.Gene;

/**
 *
 * @author gevirl
 */
public class GeneModel {
    // determine the gene(s) which contain the given genomic position
    static public List<GeneModelPosition> withinGenes(GenomePosition p)throws Exception {
        ArrayList<GeneModelPosition> ret = new ArrayList<GeneModelPosition>();
        // find a gene containing this position
        String sql = "Select * from Gene where Chromosome=? and Start<=? and End>=?";
        PreparedStatement state = MySql.getMySql().getStatement(sql);
        state.setString(1,p.chrom);
        state.setInt(2,p.pos);
        state.setInt(3,p.pos);
        ResultSet rs = state.executeQuery();
        while (rs.next()){
            Gene gene = new Gene();
            gene.fromResultSetNoExons(rs);
            if (gene.getRegion().getStrand()==-1){
                ret.add(new GeneModelPosition(gene,gene.getRegion().getEnd()-p.pos));
            } else {
                ret.add(new GeneModelPosition(gene,p.pos - gene.getRegion().getStart()));
            }
        }
        return ret;
    }
    // find the gene up from( higher chr postion)  the given genomic postition of the given strand
    static public GeneModelPosition upFrom(GenomePosition p,int strand)throws Exception {
        String sql = "select * from Gene where Chromosome=? and Strand=? and Start>? order by Start limit 1";
        PreparedStatement state = MySql.getMySql().getStatement(sql);
        state.setString(1,p.chrom);
        state.setInt(2,strand);
        state.setInt(3,p.pos);
        ResultSet rs = state.executeQuery();
        while (rs.next()){
            Gene gene = new Gene();
            gene.fromResultSetNoExons(rs);
            int pos = rs.getInt("Start") - p.pos;
            return new GeneModelPosition(gene,pos);
            
        }        
        return null;
    }
    // find the gene down from (lower chr postion) from the given genomic postition of the given strand
    static public GeneModelPosition downFrom(GenomePosition p,int strand)throws Exception {
        String sql = "select * from Gene where Chromosome=? and Strand=? and End<? order by End DESC limit 1";
        PreparedStatement state = MySql.getMySql().getStatement(sql);
        state.setString(1,p.chrom);
        state.setInt(2,strand);
        state.setInt(3,p.pos);
        ResultSet rs = state.executeQuery();
        while (rs.next()){
            Gene gene = new Gene();
            gene.fromResultSetNoExons(rs);
            int pos = p.pos - rs.getInt("End");
            return new GeneModelPosition(gene,pos);
        }        
        return null;
    }
}
