/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.views.onsetmodel;
import javax.swing.*;
import java.awt.*;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import org.rhwlab.beans.EmbryoCell;
import org.rhwlab.imaging.binarytree.DefaultColorScale;
import org.rhwlab.imaging.binarytree.TreeMark;
import org.rhwlab.imaging.binarytree.Utils;
import org.rhwlab.imaging.binarytree.VerticalTreeImage;
/**
 *
 * @author luke
 */
public class TreePanel extends JPanel {
    public TreePanel(EmbryoCell r , Dimension d,float timeScale)throws Exception {
        root = r;
//        dim = d;
        image = new VerticalTreeImage(root.fromSeries(),root,500,timeScale,500,Utils.getMaxDepth(root));
        this.addMouseListener(new MouseInputAdapter(){
            public void mouseClicked(MouseEvent event){
                String leaf = image.getLeafAt(event.getX(),event.getY());
                if (leaf == null) return;
                EmbryoCell leafCell = root.getDescendent(leaf);
                for (ChangeListener listen : listeners){
                    listen.stateChanged(new ChangeEvent(leafCell));  // notify any object listening that a leaf cell has been selected
                }
            }
        });
    }
    public void setColorScale(DefaultColorScale scale){
        image.setColorScale(scale);
    }
    public boolean addMark(TreeMark mark){
        EmbryoCell toMark = root.getDescendent(mark.getLabel());
        if (toMark == null) return false;
        
        image.addMark(mark);
        return true;
        
    }
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D) g;
        
         // clear the panel
        Color save = g2.getColor();
        g2.setColor(Color.white);
        Dimension d = this.getSize();
        g2.fillRect(0,0,d.width,d.height);
        g2.setColor(save);   
        
        g2.drawImage(image.getImage(),new AffineTransformOp(new AffineTransform(),
                AffineTransformOp.TYPE_NEAREST_NEIGHBOR),0,0);        

    }
    public void addListener(ChangeListener listen){
        listeners.add(listen);
    } 
    public Rectangle2D locateCell(String cellName){
        return image.getRectForCell(cellName);
    }
    public String leafAt(int x,int y){
        return image.getLeafAt(y);
    }
    VerticalTreeImage image;
    EmbryoCell root;
//    Dimension dim;
    ArrayList<ChangeListener> listeners = new ArrayList<ChangeListener>();    
}
