/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.views.onsetmodel;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.rhwlab.beans.SeriesEmbryo;
import org.rhwlab.expression.image.ValueRange;

/**
 *
 * @author gevirl
 */
public class ScalePanel extends JPanel {
    public ScalePanel(SeriesEmbryo emb,OnsetsScroll onsets){
        this.onsetsTimeSeriesPanel = onsets;
        this.setLayout(new BoxLayout(this,BoxLayout.X_AXIS));
        this.add(new JLabel(String.format("  %s  ",emb.getID())));
        this.add(new JLabel("Minimum: "));
        minText = new JTextField(Integer.toString(0));
        minText.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent event){
               setScale(); 
            }
        });        
        this.add(minText);
        this.add(new JLabel("Maximum: "));
        maxText = new JTextField(Integer.toString(0));
        maxText.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent event){
               setScale(); 
            }
        });
        this.add(maxText);         
        int min = emb.minExpression();
        int max = emb.maxExpression(); 
        minText.setText(Integer.toString(min));
        maxText.setText(Integer.toString(max));
        setScale();        
    }
    private void setScale(){
        Float min = Float.valueOf(minText.getText());
        Float max = Float.valueOf(maxText.getText());
        onsetsTimeSeriesPanel.setScale(new ValueRange(min,max));
        onsetsTimeSeriesPanel.validate();
       
    }
    JTextField minText;
    JTextField maxText; 
    OnsetsScroll onsetsTimeSeriesPanel;
}
