/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.views.onsetmodel;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.rhwlab.beans.EmbryoCell;
import org.rhwlab.beans.SeriesEmbryo;
import org.rhwlab.imaging.binarytree.DefaultColorScale;
import org.rhwlab.imaging.binarytree.Gradient;
import org.rhwlab.imaging.binarytree.TreeMark;
/**
 *
 * @author luke
 */
// input Dimension d is the overall size of the tree (all the roots together)
public class OnsetsTreeScroll extends JScrollPane  implements ChangeListener {
    public OnsetsTreeScroll(SeriesEmbryo emb,Dimension d)throws Exception {
        this.embryo = emb;
        roots = embryo.getRoots();
        dim = d;
        
        // divide up the overall dimension based on the number of leaves in each root
        dims = new Dimension[roots.length];
        double[] leafCounts = new double[roots.length];
        double totalLeafs = 0;
        for (int i=0 ; i<roots.length ; ++i){
            leafCounts[i] = roots[i].getLeafCount();
            totalLeafs = totalLeafs + leafCounts[i];
        }
        for (int i=0 ; i<roots.length ; ++i){
            double f = (double)leafCounts[i]/(double)totalLeafs;
            dims[i] = new Dimension(dim.width,(int)(dim.height*f));
        }
        
        // construct the panel for each root
        JPanel panel = new JPanel();
        rootPanels = new TreePanel[roots.length];
        panel.setLayout(new BoxLayout(panel,BoxLayout.Y_AXIS));
        for (int i=0 ; i<roots.length ; ++i){
            float timeScale = (dims[i].width-200)/roots[i].getEndTime();
            rootPanels[i]  = new TreePanel(roots[i],dims[i],timeScale);
            rootPanels[i].setPreferredSize(dims[i]);
            rootPanels[i].setColorScale(new DefaultColorScale(0,embryo.maxExpression(),Gradient.GRADIENT_RAINBOW));
            panel.add(rootPanels[i]);
        }
        panel.setPreferredSize(dim);
        panel.setMaximumSize(dim);
        this.setViewportView(panel);
        this.getViewport().addChangeListener(this); // this is to detect scrolling changes by user     
    }
    public void moveTo(String cellName){
        scrollToCell(cellName);
    }
    // this scroll pane is notified that it must change to view a different cell
    public void stateChanged(ChangeEvent event){
        Object source = event.getSource();
        
        if (source instanceof JViewport){
            // determine which leaf is at the top
            JViewport vp = this.getViewport();
            Point p = vp.getViewPosition();
            for (int i=0 ; i<dims.length;++i){
                if (p.y < dims[i].getHeight()) {
                    String cellName = rootPanels[i].leafAt(p.x,p.y);
                    if (cellName != null){
                        topCell = cellName;
                        notifyListeners();
                        break;
                    }
                } else {
                    p.y = p.y - (int)dims[i].getHeight();
                }
            }
        }
    }
    private void notifyListeners(){
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listen : listeners){
            listen.stateChanged(event);
        }
    }
    // add a mark to the appropriate panel
    public void addMark(TreeMark mark){
        for (TreePanel panel : rootPanels){
            if (panel.addMark(mark)) return;
        }
    }
    public void addListener(ChangeListener listen){
        listeners.add(listen);
        for (TreePanel panel : rootPanels){
            panel.addListener(listen);
        }
    }
    // scrolls the viewport vertically so that the given cell is at the top
    public void scrollToCell(String cellName){
        if (topCell.equals(cellName))return;
        Point currentPos = this.getViewport().getViewPosition();
        
        int newYPos = 0;
        for (int i=0;i< rootPanels.length ; ++i){
            TreePanel panel = rootPanels[i];
            Rectangle2D rect = panel.locateCell(cellName);
            if (rect != null){
                currentPos.setLocation(currentPos.x, newYPos+rect.getY());
                this.getViewport().setViewPosition(currentPos);
                topCell = cellName;
                return;
            }
            newYPos = newYPos + dims[i].height;
        }
        
    }
    public String getTopCell(){
        return this.topCell;
    }
    ArrayList<ChangeListener> listeners = new ArrayList<ChangeListener>();
    String topCell = "";
    Dimension dim;
    Dimension[] dims;
    SeriesEmbryo embryo;
    EmbryoCell[] roots;
    TreePanel[] rootPanels;
}
