/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.universalimaging;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.rhwlab.beans.SeriesEmbryo;
import org.rhwlab.beans.SulstonEmbryo;
import org.rhwlab.views.BufferedImagePanel;

/**
 *
 * @author gevirl
 */

/*
    Create an expression tree image using the sulston embryo as a framework onto which the imaged series are mapped
    Multiple embryos can be displayed on the sulston framework
    Each embryo is assigned a color. Expression is binary.  When there is expression, the cell is drawn with 
        the assigned color.  The cell is not draw when it is not expressing.
    The tree is drawn with time in the horizontal direction
*/
public class MultiEmbryoTreeImage {
    Embryo[] embryos;
    int[] thresholdValues;
    int[] maxExpression;
    Sulston sulstonEmbryo;
    int nThresholdValues;
    
    int leafCellHeight = 16;  // the number of pixels to use for each leaf cell - determines the size of the tree in the vertical direction  
    int pixelsPerTime = 1;  // deterimnes the time scale - horizontal size of the image
    int timeLimit;  // last sulston time to display
    boolean labelLeaves;
    int treeWidth;
    
    Graphics2D g2;
    static int labelSize = 65;
    static double strokeWidth=4;
    
    Color[] colors;
    Color[] darker;
    Font boldFont;
    Font font;
    CellLabels cellLabels;
    
    public MultiEmbryoTreeImage(Sulston sulston,Embryo[] embs,double[] thresholds,Color[] colors,int nTimes){
        this.embryos = embs;
        this.sulstonEmbryo = sulston;
        this.colors = colors;
        this.nThresholdValues = nTimes;
        
        // set some defaults
        timeLimit = sulstonEmbryo.getRoot().maxEndTime();
        treeWidth = timeLimit*pixelsPerTime;
        labelLeaves = false;
        
        thresholdValues = new int[embryos.length];
        maxExpression = new int[embryos.length];
        for (int i=0 ; i<embryos.length ; ++i){
            maxExpression[i] = embryos[i].maxExpression();
            thresholdValues[i] = (int)(maxExpression[i]*thresholds[i]);
            sulstonEmbryo.sulstonize(embryos[i]);
        }
        darker = new Color[colors.length];
        for (int i=0 ; i<colors.length ; ++i){
            darker[i] = colors[i].darker();
        }
        int aisfui=0;
    }
    public void setTimeLimit(int time){
        timeLimit = time;
        treeWidth = timeLimit*pixelsPerTime;
    }
    public BufferedImage getScaleImage(String lineageRoot){
        int st = sulstonEmbryo.getCell(lineageRoot).getStartTime();
        BufferedImage image = new BufferedImage(treeWidth  + labelSize, 40, BufferedImage.TYPE_INT_ARGB);
        Graphics2D g = image.createGraphics(); 
        for (int i =0 ; i<timeLimit ; i = i + 50){
            g.setColor(Color.black);
            int pos = i-st;
            if (pos > 0){
                g.drawString(String.format("%d",i), pos*pixelsPerTime, 20);
            }
        }
//        g.drawString(String.format("%d",timeLimit), timeLimit*pixelsPerTime, 20);
        return image;  
    }
    public BufferedImage getImage(String lineageRoot)throws Exception {
        if (cellLabels == null){
            cellLabels = new CellLabels();
        }
        // calculate the size of the image
        
        int nLeaves = sulstonEmbryo.getCell(lineageRoot).getLeaves(timeLimit).size();
        
        int h = nLeaves*leafCellHeight;
        int labelPixels = 0;
        if (labelLeaves){
            labelPixels = labelSize;
        }
        BufferedImage image = new BufferedImage(treeWidth + labelPixels, h, BufferedImage.TYPE_INT_ARGB);
        g2 = image.createGraphics();
        BasicStroke stroke = new BasicStroke(1);
        font = g2.getFont();
        boldFont = font.deriveFont(Font.BOLD);
        g2.setStroke(stroke);
        
        drawCell(sulstonEmbryo.getCell(lineageRoot), 0 , 0 , h );
        return image;
    }
    
    // draw the cell into the image at starting at locatioon (x,y) using height pixels in the vertical direction
    // return the y position where the cell was draw
    private double drawCell(Cell sulstonCell,double xLeft,double yUpper,double height)throws Exception {

        double horizontalLength = pixelsPerTime*(Math.min(timeLimit, sulstonCell.getEndTime()) - sulstonCell.getStartTime());
        Cell[] sulstonChildren = sulstonCell.getChildrenCells();
        double x = xLeft;
        double y = yUpper + height/2;
        if (sulstonChildren.length > 0 && sulstonCell.getEndTime()<timeLimit){
            int nLeaves0 = sulstonChildren[0].getLeaves(timeLimit).size();
            int nLeaves1 = sulstonChildren[1].getLeaves(timeLimit).size();
            int nTotal = nLeaves0 + nLeaves1;   
            int h0 = (int) (height*(double)nLeaves0/(double)nTotal);
            double h1 = height - h0;  
            double nextX = x+horizontalLength+pixelsPerTime;
            
            // draw the children
            double y0 = drawCell(sulstonChildren[0], nextX , yUpper , h0);
            double y1 = drawCell(sulstonChildren[1], nextX , yUpper+h0 , h1);   
            
            // draw the vertical segment
            g2.setColor(Color.BLACK);
            g2.drawLine((int)nextX, (int)y0, (int)nextX, (int)y1);  

            
        } else {
            // it is a leaf
            if (this.labelLeaves){
                String label = cellLabels.getLabel(sulstonCell.getName());
                if (label == null){
                    label = sulstonCell.getName();
                }else {
//                    label = String.format("%s %s",sulstonCell.getName(),label);
                    label = sulstonCell.getName();
                }
                g2.setColor(Color.black);
                if ( x+horizontalLength < treeWidth-20){
                    g2.setFont(font);
   //                 g2.drawString("X", (int)(x+horizontalLength+5), (int)y);
                    g2.drawString(label,(int)(x+horizontalLength+5), (int)y);
                } else {
                    g2.setFont(boldFont);
                    g2.drawString(label, treeWidth, (int)y);
                }
            }
        }
        // draw the horizontal segment       
        if (horizontalLength > 0){
            // determine which cells are to be shown expressing at this point in the tree
            TreeSet<Integer> expressingCells = new TreeSet<>(); 
            Cell[] cells = new Cell[embryos.length];
            for (int i=0 ; i<cells.length ; ++i){
                cells[i] = embryos[i].getCell(sulstonCell.getName());
            }
            
            for (int i=0 ; i<cells.length ; ++i){
                Cell testCell = cells[i];
                Cell currentSulston = sulstonCell;
                while (testCell==null) {
                    Cell parent = currentSulston.getParentAsCell();
                    if (parent == null){
                        break;
                    }
                    testCell = embryos[i].getCell(parent.getName());
                    currentSulston = parent;
                }
                if (testCell!=null && testCell.isAfterOnset(thresholdValues[i], nThresholdValues)){
                    Integer onset = testCell.sulstonTimeOnset(thresholdValues[i], nThresholdValues);
                    if (onset == null){
                        expressingCells.add(i);
                    }
                    else if  (onset < sulstonCell.getEndTime())
                        expressingCells.add(i);
                }                
            }

            double xr = x;
            for (int sulTime=sulstonCell.getStartTime() ; sulTime<=Math.min(timeLimit,sulstonCell.getEndTime()) ; ++sulTime){

                if (expressingCells.isEmpty() ){
                    double cellheight = strokeWidth;
                    int yr = (int)(y - cellheight/2.0);                     
                    g2.setColor(Color.black);
                    Rectangle2D.Double r = new Rectangle2D.Double(xr,yr,pixelsPerTime,strokeWidth);
                    g2.fill(r); 
                } else {
                    double cellheight = strokeWidth*expressingCells.size();
                    double yr = (y - cellheight/2.0); 
                    for (Integer i : expressingCells) {
                        Color c = Color.black;
                        if (cells[i] != null){
                            Cell parent = cells[i].getParentAsCell();
                            if (parent != null && parent.isAfterOnset(thresholdValues[i], nThresholdValues)){
                                c = colors[i];
                            } 
                            else {
                                Integer expOnset = cells[i].sulstonTimeOnset(thresholdValues[i], nThresholdValues);
                                if (expOnset == null){
                                    c = Color.black;
                                } else {
                                    if (expOnset <= sulTime){
                                        c = colors[i];
                                    } else {
                                        c = Color.black;
                                    }
                                }
                            }
                        } else {
                            c = colors[i];
                        }
                        g2.setColor(c);
                        Rectangle2D.Double r = new Rectangle2D.Double(xr,yr,pixelsPerTime,strokeWidth);
                        g2.fill(r);
                        yr = yr + strokeWidth;
                    }
                }
                xr = xr + pixelsPerTime;
            }

        }
        return y;
    }
    private void drawMultiLine(int x,int yMid,int len,Color[] colors){
        double height = strokeWidth*colors.length;
        double y = yMid - height/2.0;
        for (int i=0 ; i<colors.length ; ++i){
            g2.setColor(colors[i]);
            Rectangle2D.Double r = new Rectangle2D.Double(x,y,len,strokeWidth);
            g2.draw(r);
            y = y + strokeWidth+1;
        }    
    }
    public void setLabelLeaves(boolean label){
        this.labelLeaves = label;
    }

    
}
