/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.universalimaging;

import java.awt.Color;
import java.io.File;
import java.io.PrintStream;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.rhwlab.beans.SeriesEmbryo;
import org.rhwlab.beans.SulstonEmbryo;
import org.rhwlab.views.BufferedImagePanel;

/**
 *
 * @author gevirl
 */
public class FACSLineageTree {

    static public void displayTrees(Embryo[] embryos, String[] lineages, int timeLimit, Color[] colors, Sulston sulton, double[] thresholds, int nTimes) throws Exception {
        for (String lineage : lineages) {
            JFrame frame = new JFrame();
            frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
            MultiEmbryoTreeImage image = new MultiEmbryoTreeImage(sulton, embryos, thresholds, colors, nTimes);
            image.setLabelLeaves(true);
            image.setTimeLimit(timeLimit);
            BufferedImagePanel panel = new BufferedImagePanel(image.getImage(lineage));
            JScrollPane scroll = new JScrollPane(panel);
            SeriesColorLegend legend = new SeriesColorLegend(embryos, colors);
            JPanel mainPanel = new JPanel();
            mainPanel.setLayout(new BoxLayout(mainPanel, BoxLayout.Y_AXIS));
            //        mainPanel.add(legend);
            mainPanel.add(new BufferedImagePanel(image.getScaleImage(lineage)));
            mainPanel.add(scroll);
            frame.setContentPane(mainPanel);
            //       frame.getContentPane().add(scroll);
            frame.pack();
            frame.setVisible(true);
        }
        JFrame legendFrame = new JFrame();
        legendFrame.getContentPane().add(new SeriesColorLegend(embryos, colors));
        legendFrame.pack();
        legendFrame.setVisible(true);
    }

    static public void expressingCells(Embryo[] embryos, int timeLimit, Sulston sulston, double[] thresholds, int nTimes, File dir) throws Exception {
        CellLabels labels = new CellLabels();
        for (int i = 0; i < embryos.length; ++i) {
            Embryo embryo = embryos[i];
            double maxExpression = embryo.maxExpression();
            int thresholdValue = (int) (maxExpression * thresholds[i]);
            File outFile = new File(dir, String.format("%s_time%d", embryo.getID(), timeLimit));
            PrintStream stream = new PrintStream(outFile);
            for (Cell root : embryo.getRoots()) {
                listExpressingCells(root, thresholdValue, nTimes, stream, sulston, labels, timeLimit);
            }
            stream.close();
        }
    }

    static public void listExpressingCells(Cell cell, int threshold, int nTimes, PrintStream stream, Sulston sulston, CellLabels labels, int timeLimit) throws Exception {
        Cell sulstonCell = sulston.getCell(cell.getName());
        if (cell.isAfterOnset(threshold, nTimes)) {
            Integer onset = cell.sulstonTimeOnset(threshold, nTimes);
            if (onset == null || onset < timeLimit) {
                Cell[] leaves = sulstonCell.getLeaves();
                for (Cell leaf : leaves) {
                    String leafName = leaf.getName();
                    if (leafName.equals("ABplapapaa") || leafName.equals("ABprapapaa")) {
                        stream.printf("%s\n", labels.getLabel(leaf.getName() + "p"));
                        stream.printf("%s\n", labels.getLabel(leaf.getName() + "a"));
                    } else {
                        String cellLabel = labels.getLabel(leaf.getName());
                        if (cellLabel == null) {
                            stream.printf("%s null\n", leaf.getName());
                        } else {
                            stream.printf("%s\n", cellLabel);
                        }
                    }
                }
            }
        } else {
            Cell[] children = cell.getChildrenCells();
            if (children.length > 0) {
                for (Cell child : children) {
                    listExpressingCells(child, threshold, nTimes, stream, sulston, labels, timeLimit);
                }
            }
        }
    }

    static public void main(String[] args) throws Exception {
        int nTimes = -5;
        int timeLimit = 225;

        Sulston sulston = new SulstonEmbryo();
        int count = 0;
        for (Cell rootCell : sulston.getRoots()) {
            Cell[] rootLeaves = rootCell.getLeaves();
            for (Cell cell : rootLeaves) {
                System.out.println(cell.getName());
                if (cell.getName().equals("ABplppppppa")) {
                    int tjkasdfusd = 0;
                }
            }
//            System.out.printf("%s %d\n",rootCell.getName(),rootLeaves.length);
            count = count + rootLeaves.length;
        }
        //       System.out.printf("Total: %d\n", count);

        Embryo[] embryos = new Embryo[7];
        double[] thresholds = new double[7];
        embryos[3] = new SeriesEmbryo("20070904_hlh-1_4");
        embryos[2] = new SeriesEmbryo("20071015_end-1_1");
        embryos[5] = new SeriesEmbryo("20080507_pha-4_3E3C5_1");
        embryos[0] = new SeriesEmbryo("20090526_ceh-32_13_L2");
        embryos[1] = new SeriesEmbryo("20060714_cnd1_3");
        embryos[4] = new SeriesEmbryo("20071008_nhr-25_h4_8");
        embryos[6] = new SeriesEmbryo("20080912_tbx-37_b12_L1");
        thresholds[0] = .1;
        thresholds[1] = .1;
        thresholds[2] = .1;
        thresholds[3] = .1;
        thresholds[4] = .1;
        thresholds[5] = .1;
        thresholds[6] = .1;
        Color[] colors = new Color[7];

        /*        
        colors[0] = new Color(243,200,0);
        colors[1] = new Color(190,18,213);
        colors[2] = new Color(68,237,63);
        colors[3] = new Color(255,63,95);
        colors[4] = new Color(2,155,153);
        colors[5] = new Color(154,41,0);
        colors[6] = new Color(255,173,184);     
         */
        colors[3] = new Color(255, 255, 0);
        colors[2] = new Color(0, 0, 255);
        colors[5] = new Color(0, 255, 255);
        colors[0] = new Color(255, 0, 0);
        colors[1] = new Color(0, 255, 0);
        colors[4] = new Color(255, 0, 255);
        colors[6] = new Color(125, 0, 255);
        String[] lineages = {"P2", "EMS", "ABpr", "ABpl", "ABar", "ABal"};
        displayTrees(embryos, lineages, timeLimit, colors, sulston, thresholds, nTimes);

        File dir = new File("/net/waterston/vol2/home/gevirl/FACS");
        expressingCells(embryos, timeLimit, sulston, thresholds, nTimes, dir);
    }
}
