/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.universalimaging;

import java.util.List;

/**
 *
 * @author gevirl
 */
public interface Cell {
    public double embryoTime(double sulstonTime) throws Exception ;  // calculates the embryo time for a given sulston time
    public int getStartTime();  // embryoTime start
    public int getEndTime();    // embryTime end
    public int maxEndTime();  // the maximum embryoTime over all descendents
    public double[] getPosition(int embryoTime);  // the 3d position of the cell at the given embryoTime
    public double sphereRadius(int embryoTime);  // the best estimate for a single radius for the cell at the given embryoTime
    public Cell[] getChildrenCells();  // returns zero length array if not children
    public Cell[] getLeaves();  // the leaves under the given cell
    public List<Cell> getLeaves(int time);  // get the leaves at the given time
    public String getName();
    public boolean sulstonize(Sulston sulstonEmbryo,double averageRatio);
    public Integer getExpressionBySulstonTime(int sulstonTime)throws Exception ;
    public boolean isAfterOnset(int threshold,int ntimes) throws Exception ;
    public Integer sulstonTimeOnset(int threshold,int ntimes) throws Exception ;
    public Cell getParentAsCell();
}
