/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.singlecell.randomforest;

import org.rhwlab.chipseq.ImportanceAnnotatedBedRecord;
import org.rhwlab.chipseq.AnnotatedChipSeqBedFile;
import htsjdk.samtools.util.Interval;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.table.AbstractTableModel;
import org.rhwlab.db.MySql;
import org.rhwlab.meme.FimoFile;
import org.rhwlab.singlecell.L2.CellTypeGeneExp;

/**
 *
 * @author gevirl
 */
public class TargetTableModel extends AbstractTableModel {

    ArrayList<String> columnNames = new ArrayList<>();
    String tf;
    List<List<Object>> data = new ArrayList<>();
    TreeMap<String, Integer> motifColumns = new TreeMap<>();

    public TargetTableModel(String tf, String expFile) throws Exception {
        this(tf, expFile, null, null);
    }

    public TargetTableModel(String tf, String expFile, String[] abbrs, TreeMap<String, double[]> expData) throws Exception {
        columnNames.add("Target");
        columnNames.add("Importance");
        columnNames.add("Norm Across TFs (Max=1)");
        columnNames.add("Rank Among TFs");
        columnNames.add("Exp Desc");
        columnNames.add("Peak Stages");
        columnNames.add("ClusterTFs");
        this.tf = tf;
        PreparedStatement state = MySql.getMySql().getStatement("Select * from ScoredTargetTFs where ExpressionFile = ? and TF = ? order by Importance desc");
        state.setString(1, expFile);
        state.setString(2, tf);
        ResultSet rs = state.executeQuery();
        while (rs.next()) {
            Object[] objs = new Object[7];
            objs[0] = rs.getString("TargetGene");
            objs[1] = rs.getDouble("Importance");
            objs[2] = rs.getDouble("NormalizedImportance");
            objs[3] = rs.getInt("RankForTargetInFile") + 1;
            objs[4] = "";
            objs[5] = "";
            objs[6] = 0;

            if (abbrs != null && expData != null) {
                double[] x = expData.get((String) objs[0]);
                if (x != null) {
                    String brief = CellTypeGeneExp.briefDesc(x, abbrs);
                    if (brief != null) {
                        objs[4] = brief;
                    }
                }
            }
            this.addRow(objs);
        }

    }

    public AnnotatedChipSeqBedFile restoreAllPeaks(AnnotatedChipSeqBedFile allPeaksbed) {
        AnnotatedChipSeqBedFile remaining = new AnnotatedChipSeqBedFile();
        for (int r = 0; r < this.getRowCount(); ++r) {
            String target = (String) this.getValueAt(r, 0);
            TreeMap<String, List<ImportanceAnnotatedBedRecord>> tfMap = allPeaksbed.getRecordsForTarget(target);
            List<ImportanceAnnotatedBedRecord> recs = tfMap.get(tf);
            if (recs != null) {
                for (ImportanceAnnotatedBedRecord rec : recs) {
                    remaining.addRecord(rec);  // adds the record for all targets, does not add duplicate records
                }
            }
        }
        return remaining;
    }

    public AnnotatedChipSeqBedFile filterBed(AnnotatedChipSeqBedFile allPeaksbed, double importance) {
        return filterBed(allPeaksbed, importance, Double.MAX_VALUE, -1, "And");
    }

    public AnnotatedChipSeqBedFile filterBed(AnnotatedChipSeqBedFile allPeaksbed, double importance, double normImp, int rank, String relation) {
        AnnotatedChipSeqBedFile remaining = new AnnotatedChipSeqBedFile();
        for (int r = 0; r < this.getRowCount(); ++r) {
            Double tableImportance = (Double) this.getValueAt(r, 1);
            Double tableNormImp = (Double) this.getValueAt(r, 2);
            int tableRank = (Integer) this.getValueAt(r, 3);
            boolean remove;
            if (relation.equals("And")) {
                remove = tableImportance < importance && tableNormImp < normImp && tableRank > rank;
            } else {
                remove = tableImportance < importance || tableNormImp < normImp || tableRank > rank;
            }

            if (!remove) {
                String target = (String) this.getValueAt(r, 0);
                TreeMap<String, List<ImportanceAnnotatedBedRecord>> tfMap = allPeaksbed.getRecordsForTarget(target);
                List<ImportanceAnnotatedBedRecord> recs = tfMap.get(tf);
                if (recs != null) {
                    for (ImportanceAnnotatedBedRecord rec : recs) {
                        remaining.addRecord(rec);  
                    }
                }
            }
        }
        return remaining;
    }

    public int updatePeakColumns(AnnotatedChipSeqBedFile bed) {

        if (bed != null) {
            for (int r = 0; r < this.getRowCount(); ++r) {
                String target = (String) this.getValueAt(r, 0);
                TreeMap<String, List<ImportanceAnnotatedBedRecord>> tfMap = bed.getRecordsForTarget(target);
                List<ImportanceAnnotatedBedRecord> recs = tfMap.get(tf);
                if (recs != null) {
                    StringBuilder builder = new StringBuilder();
                    builder.append(recs.get(0).getStage());
                    for (int i = 1; i < recs.size(); ++i) {
                        builder.append(",");
                        builder.append(recs.get(i).getStage());
                    }
                    this.setValueAt(builder.toString(), r, 5);

                    builder = new StringBuilder();
                    builder.append(recs.get(0).getClusterSize());
                    for (int i = 1; i < recs.size(); ++i) {
                        builder.append(",");
                        builder.append(recs.get(i).getClusterSize());
                    }
                    this.setValueAt(builder.toString(), r, 6);
                } else {
                    this.setValueAt("", r, 5);
                    this.setValueAt("", r, 6);
                }
            }
        }
        return bed.getRecordsForTF(tf).size();
    }

    public void updateMotifColumns(FimoFile motifFile, AnnotatedChipSeqBedFile bed) {
        // remove previous motif columns if any
        for (String motifCol : motifColumns.keySet()) {
            this.removeColumn(motifCol);
        }
        motifColumns.clear();

        for (String motifID : motifFile.getMotifIDs()) {
            int col = this.addColumn(motifID);
            motifColumns.put(motifID, col);
        }
        if (bed != null) {
            for (int r = 0; r < this.getRowCount(); ++r) {
                String target = (String) this.getValueAt(r, 0);
                TreeMap<String, List<ImportanceAnnotatedBedRecord>> tfMap = bed.getRecordsForTarget(target);
                List<ImportanceAnnotatedBedRecord> recs = tfMap.get(tf);
                if (recs != null) {
                    for (ImportanceAnnotatedBedRecord rec : recs) {
                        Interval peakInt = new Interval(rec.getChromosome(), rec.getStart(), rec.getEnd());
                        TreeMap<String, Collection> motifs = motifFile.getContainedIn(peakInt);
                        for (String motifID : motifs.keySet()) {
                            if (!motifs.get(motifID).isEmpty()) {
                                int c = motifColumns.get(motifID);
                                String currentValue = (String)this.getValueAt(r, c);
                                String motifDesc  = String.format("%s-%d",rec.getTargetClass(),rec.getClusterSize());
                                if (currentValue.equals("")){
                                    this.setValueAt(motifDesc, r, c);
                                } else {
                                    this.setValueAt(currentValue+","+motifDesc, r, c);
                                }
                            }
                        }
                    }

                }
            }
        }
        this.fireTableStructureChanged();
    }

    @Override
    public Class getColumnClass(int c) {
        Object obj = getValueAt(0, c);
        if (obj == null) {
            int ashhs = 0;
        }
        return getValueAt(0, c).getClass();
    }

    public void addRow(Object[] row) {
        ArrayList<Object> rowList = new ArrayList<>();
        for (int i = 0; i < row.length; ++i) {
            rowList.add(row[i]);
        }
        data.add(rowList);
    }

    // add an empty column
    public int addColumn(String name) {
        columnNames.add(name);
        for (List<Object> row : data) {
            row.add("");
        }
        return columnNames.size() - 1;
    }

    @Override
    public String getColumnName(int col) {
        return columnNames.get(col);
    }

    @Override
    public int getRowCount() {
        return data.size();
    }

    @Override
    public int getColumnCount() {
        return columnNames.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return data.get(rowIndex).get(columnIndex);
    }

    @Override
    public void setValueAt(Object value, int r, int c) {
        List<Object> objs = data.get(r);
        objs.set(c, value);
    }

    public void removeColumn(String name) {
        for (int i = 0; i < columnNames.size(); ++i) {
            if (columnNames.get(i).equals(name)) {
                removeColumn(i);
            }
        }
    }

    public void removeColumn(int col) {
        columnNames.remove(col);
        for (List<Object> rowData : this.data) {
            rowData.remove(col);
        }
    }

}
