/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.singlecell.L2;

import java.awt.BorderLayout;
import java.awt.Panel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Map.Entry;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.commons.math3.stat.StatUtils;
import org.rhwlab.gene.model.DeadGenes;
import org.rhwlab.gene.model.ModelFromGFF;
import org.rhwlab.tfs.AllTFs;

/**
 *
 * @author gevirl
 */
public class CellTypeGeneExp {

    File csv;
    static final TreeMap<String, String> abbrMap = new TreeMap<>();

    public CellTypeGeneExp(File csv) {
        this.csv = csv;

    }

    static public String briefDesc(double[] x,String[] abrs) {
        String ret = null;
        double mu = StatUtils.mean(x);
        if (mu > 0.0) {
            double sd = Math.sqrt(StatUtils.variance(x, mu));
            TreeMap<Double, String> labelsMap = new TreeMap<>();
            for (int i = 0; i < x.length; ++i) {
                if (x[i] - mu > sd) {
                    labelsMap.put(x[i], abrs[i]);
                }
            }

            if (!labelsMap.isEmpty()) {
                ArrayList<String> labels = new ArrayList<>();
                for (String label : labelsMap.descendingMap().values()) {
                    labels.add(label);
                }
                StringBuilder builder = new StringBuilder();
                builder.append(labels.get(0));
                for (int i = 1; i < labels.size(); ++i) {
                    builder.append("/");
                    builder.append(labels.get(i));
                }
                ret = builder.toString();
            }
        }
        return ret;
    }

    static public String getAbbr(String name) {
        return abbrMap.get(name);
    }

    public String[] getCellTypes() throws Exception {
        return getCellTypes(csv);
    }

    static public String[] getCellTypeAbbrs(File file) throws Exception {

        String[] ret = getCellTypes(file);
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = getAbbr(ret[i]);
        }
        int ohsdifuh = 0;
        return ret;
    }

    static public String[] getCellTypes(File file) throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = reader.readLine();
        String[] ret = line.split(",");
        reader.close();
        return ret;
    }

    public TreeMap<String, double[]> getWBGeneExpression(String[] wbGenes) throws Exception {
        return getWBGeneExpression(wbGenes, csv);
    }

    static public TreeMap<String, double[]> getWBGeneExpression(String[] wbGenes, File file) throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = reader.readLine();

        TreeSet<String> wbGeneSet = new TreeSet<>();
        for (String wbGene : wbGenes) {
            wbGeneSet.add(wbGene);
        }

        TreeMap<String, double[]> map = new TreeMap<>();
        line = reader.readLine();
        while (line != null) {
            String[] tokens = line.split(",");
            if (wbGeneSet.contains(tokens[0])) {
                double[] x = new double[tokens.length - 1];
                for (int c = 1; c < tokens.length; ++c) {
                    x[c - 1] = Double.valueOf(tokens[c]);
                }
                map.put(tokens[0], x);
            }
            line = reader.readLine();
        }
        reader.close();
        return map;
    }

    static public double[] getGeneExpression(String gene, File ssfile, ModelFromGFF gff3) throws Exception {
        String[] geneArray = new String[1];
        geneArray[0] = gene;
        TreeMap<String, double[]> map = getGeneExpression(geneArray, ssfile, gff3);
        return map.get(gene);
    }

    static public TreeMap<String, double[]> getGeneExpression(String[] genes, File ssfile, ModelFromGFF gff3) throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(ssfile));
        String line = reader.readLine();  // skip the header

        TreeMap<String, String> geneMap = new TreeMap<>();  // wbgene,genename
        for (String gene : genes) {
            String wbGene = gff3.getWBGene(gene);
            if (wbGene != null) {
                geneMap.put(wbGene, gene);
            }
        }

        TreeMap<String, double[]> map = new TreeMap<>();  // genename,values
        line = reader.readLine();
        while (line != null) {
            String[] tokens = line.split(",");
            String wbGene = tokens[0];
            String genename = geneMap.get(wbGene);
            if (genename != null) {
                double[] x = new double[tokens.length - 1];
                for (int c = 1; c < tokens.length; ++c) {
                    x[c - 1] = Double.valueOf(tokens[c]);
                }
                map.put(genename, x);
            }
            line = reader.readLine();
        }
        reader.close();
        return map;
    }

    static public TreeMap<String, double[]> getAllGeneExpression(File ssfile, ModelFromGFF gff3) throws Exception {
        return getAllGeneExpression(ssfile, gff3, 1);
    }

    static public TreeMap<String, double[]> getAllGeneExpression(File ssfile, ModelFromGFF gff3, int index) throws Exception {
        DeadGenes dead = new DeadGenes();

        BufferedReader reader = new BufferedReader(new FileReader(ssfile));
        String line = reader.readLine();  // skip the header

        TreeMap<String, double[]> map = new TreeMap<>();  // genename,values
        line = reader.readLine();
        while (line != null) {
            String[] tokens = line.split(",");
            String wbGene = tokens[0];

            if (!dead.isDead(wbGene)) {

                String[] geneIDs = gff3.geneNameTriplet(wbGene);

                if (geneIDs != null) {

                    double[] x = new double[tokens.length - 1];
                    for (int c = 1; c < tokens.length; ++c) {
                        x[c - 1] = Double.valueOf(tokens[c]);
                    }
                    double[] exists = map.get(geneIDs[index]);

                    map.put(geneIDs[index], x);
                }
            }
            line = reader.readLine();
        }
        reader.close();
        return map;
    }

    static public TreeMap<String, double[]> normalizeToLengthOne(TreeMap<String, double[]> m) {
        for (double[] vs : m.values()) {
            double sum = 0.0;
            for (int c = 0; c < vs.length; ++c) {
                sum = sum + vs[c] * vs[c];
            }
            sum = Math.sqrt(sum);

            if (sum > 0.0) {
                for (int c = 0; c < vs.length; ++c) {
                    vs[c] = vs[c] / sum;
                }
            }
        }
        return m;
    }

    static public TreeMap<String, double[]> lengthOneTFs(File file) throws Exception {
        CellTypeGeneExp exp = new CellTypeGeneExp(file);
        AllTFs all = new AllTFs();
        String[] wbGenes = all.asWBGene().toArray(new String[0]);
        return normalizeToLengthOne(exp.getWBGeneExpression(wbGenes));
    }

    static public JPanel getLegendPanel() {
        JPanel ret = new JPanel();
        ret.setLayout(new BorderLayout());

        TreeMap<String, String> abbr = new TreeMap();
        for (Entry e : abbrMap.entrySet()) {
            abbr.put((String) e.getValue(), (String) e.getKey());
        }

        DefaultListModel model = new DefaultListModel();
        for (String key : abbr.keySet()) {
            model.addElement(String.format("%s - %s", key, abbr.get(key)));
        }

        JList jList = new JList(model);
        JScrollPane scroll = new JScrollPane(jList);
        ret.add(scroll, BorderLayout.CENTER);
        return ret;
    }

    // filter genes by expression. Gene is retained if any value goes above threshold
    static public void filterByValuedouble(double thresh, File ssfile, ModelFromGFF gff3, File outFile) throws Exception {

        String[] cellTypes = getCellTypes(ssfile);
        PrintStream stream = new PrintStream(outFile);
        stream.print(cellTypes[0]);
        for (int i = 1; i < cellTypes.length; ++i) {
            stream.printf(",%s", cellTypes[i]);
        }
        stream.println();

        TreeMap<String, double[]> allGenes = getAllGeneExpression(ssfile, gff3, 2);
        for (String wbGene : allGenes.keySet()) {
            boolean retain = false;
            double[] values = allGenes.get(wbGene);
            for (double value : values) {
                if (value >= thresh) {
                    retain = true;
                    break;
                }
            }
            if (retain) {
                stream.print(wbGene);
                for (int i = 0; i < values.length; ++i) {
                    stream.printf(",%s", Double.toString(values[i]));
                }
                stream.println();
            }
        }
        stream.close();
    }

    static public void main(String[] args) throws Exception {
        //       
        ModelFromGFF gff3 = new ModelFromGFF(new File("/net/waterston/vol9/References/WS260/c_elegans.PRJNA13758.WS260.annotations.WormBase.gff3"));
        File inFile = new File("/net/waterston/vol2/home/gevirl/SingleCell_L2_GenesByCellTypes_TPM.csv");
        File outFile = new File("/net/waterston/vol2/home/gevirl/SingleCell_L2_GenesByCellTypes_TPM_20.0.csv");
        CellTypeGeneExp.filterByValuedouble(20.0, inFile, gff3, outFile);

        int sdus = 0;
    }

    static {

        abbrMap.put("Canal associated neurons", "Ca");
        abbrMap.put("Germline", "Ge");
        abbrMap.put("Ciliated sensory neurons", "Ci");
        abbrMap.put("Rectum", "Re");
        abbrMap.put("Intestine", "In");
        abbrMap.put("Am/PH sheath cells", "Am");
        abbrMap.put("Excretory cells", "Ex");
        abbrMap.put("flp-1(+) interneurons", "fl");
        abbrMap.put("Other interneurons", "Ot");
        abbrMap.put("Vulval precursors", "Vu");
        abbrMap.put("Somatic gonad precursors", "So");
        abbrMap.put("Pharyngeal muscle", "PM");
        abbrMap.put("Pharyngeal gland", "PG");
        abbrMap.put("Body wall muscle", "Bd");
        abbrMap.put("Intestinal/rectal muscle", "IR");
        abbrMap.put("Dopaminergic neurons", "Do");
        abbrMap.put("Non-seam hypodermis", "No");
        abbrMap.put("Touch receptor neurons", "To");
        abbrMap.put("Cholinergic neurons", "Ch");
        abbrMap.put("Coelomocytes", "Co");
        abbrMap.put("Pharyngeal epithelia", "PE");
        abbrMap.put("Distal tip cells", "Ds");
        abbrMap.put("Sex myoblasts", "Sx");
        abbrMap.put("Seam cells", "Se");
        abbrMap.put("Socket cells", "Sk");
        abbrMap.put("GABAergic neurons", "GA");
        abbrMap.put("Pharyngeal neurons", "PN");
        abbrMap.put("Oxygen sensory neurons", "Ox");
    }
}
