/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.mysql;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.TreeMap;
import org.rhwlab.db.MySql;
import org.rhwlab.db.beans.GeneRegion;

/**
 *
 * @author gevirl
 */

public class WBGeneAnnotation {
    public WBGeneAnnotation(){
        if (chromoSizeMap == null){
            chromoSizeMap = new TreeMap<>();
            chromoSizeMap.put("I",  new Integer(15072434));
            chromoSizeMap.put("II" ,new Integer(15279421));
            chromoSizeMap.put("III",new Integer(13783801));
            chromoSizeMap.put("IV", new Integer(17493829));
            chromoSizeMap.put("V",  new Integer(20924180));
            chromoSizeMap.put("X",  new Integer(17718942));
            chromoSizeMap.put("MtDNA", new Integer(13794));
        }
    }
    public void fromResultSet(ResultSet rs)throws Exception{
        if (rs.next()){
            this.biotype = rs.getString("BioTYpe");
            this.chromo = rs.getString("Chromosome");
            this.end = rs.getInt("End");
            this.sequence = rs.getString("Sequence");
            this.start = rs.getInt("Start");
            this.strand = rs.getString("Strand");
            this.wbGene = rs.getString("WBGene");
        }
    }
    static public WBGeneAnnotation fromWBGene(String wbGene)throws Exception{
        WBGeneAnnotation ret = new WBGeneAnnotation();
        String sql = String.format("Select * from WBGeneAnnotation where WBGene=\'%s\'",wbGene);
        ResultSet rs = MySql.getMySql().execute(sql);
        ret.fromResultSet(rs);
        return ret;
    }
    static public void loadFromGFF3(File gff3)throws Exception{
        // remove all previous annotations
        String sql = "Delete from WBGeneAnnotation";
        MySql.getMySql().execute(sql);
        
        if (gff3 == null){
            gff3 = new File("/net/waterston/vol2/home/gevirl/Desktop/WormBase/WormBaseGeneAnnotations.gff3");
        }
        
        sql = "insert into WBGeneAnnotation values (?,?,?,?,?,?,?,?)";
        PreparedStatement state = MySql.getMySql().getStatement(sql);
        BufferedReader reader = new BufferedReader(new FileReader(gff3));
        String line = reader.readLine();
        while(line !=null){
            String[] tokens = line.split("\t");
            String[] attrs = tokens[8].split(";");
            TreeMap<String,String> attrMap = new TreeMap<>();
            for (String attr : attrs){
                String[] entrys = attr.split("=");
                attrMap.put(entrys[0], entrys[1]);
            }
            state.setInt(1, Integer.valueOf(tokens[3]));
            state.setInt(2, Integer.valueOf(tokens[4]));
            state.setString(3, tokens[6]);
            state.setString(4, tokens[8]);
            state.setString(5, attrMap.get("sequence_name"));
            state.setString(6, attrMap.get("Name"));
            state.setString(7, tokens[0]);
            state.setString(8, attrMap.get("biotype"));
            state.execute();
            
            line = reader.readLine();
        }
        reader.close();
    }
    public GeneRegion getRegion(){
        int s =-1;
        if (this.strand.equals("+")){
            s = 1;
        }
        GeneRegion ret = new GeneRegion(chromo,start,end,s);
        return ret;
    }
    public String getStrandLabel(){
        if (strand.equals("+"))
            return "-->";
        return "<--";
    }  
    public String getName(){
        return sequence;
    }
    public String getWBGene(){
        return this.wbGene;
    }
    static public int getChromosomeSize(String ch){
        return chromoSizeMap.get(ch);
    }
    static public void main(String[] args) throws Exception{
        WBGeneAnnotation.loadFromGFF3(null);
    }
    static TreeMap<String,Integer> chromoSizeMap;
    String wbGene;
    String sequence;
    int start;
    int end;
    String chromo;
    String strand;
    String biotype;
}
