/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.mysql;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.TreeSet;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */
public class Intron {
    public Intron(String name){
        id = name;
        String[] nameTokens = name.split("_");
        chrom = nameTokens[1];
        start = Integer.valueOf(nameTokens[2]);
        end = Integer.valueOf(nameTokens[3]);
        strand = nameTokens[4];        
    }
    // find all the WormBase transcripts that can contain this intron
    public void locateWormBaseTranscripts(String[] trans)throws Exception {
        if (id.equals("intron_III_10114785_10114949_+_wb220")){
            int iusdfiuas=0;
        }
        for (String tran : trans){
            if (isWormBaseTranscript(tran)){
                transcripts.add(tran);
            }else {
                String sql = String.format("Select Transcript from WormBaseTranscript T where "
                        + "T.Chromosome=\'%s\' and  "
                        + "((T.Start<=%d and T.End>=%d) or (T.Start<=%d and T.End>=%d))",
                        chrom,start,start,end,end);
                ResultSet rs = MySql.getMySql().execute(sql);
                while (rs.next()){
                    transcripts.add(rs.getString("Transcript"));
                }
                if (transcripts.isEmpty()){
                    int sdhiaduh=0;
                }
            }
        }

    }
    static private boolean isWormBaseTranscript(String tran)throws Exception {
        String sql = String.format("Select * from WormBaseTranscript where Transcript=\'%s\'",tran);
        ResultSet rs = MySql.getMySql().execute(sql);
        return rs.next();
    }
    public static void loadFromDCPMFile(File file) throws Exception {
        
        PreparedStatement intronInsert = MySql.getMySql().getStatement("Insert into Intron (Intron,Chromosome,Start,End,Strand) values (?,?,?,?,?)");
        PreparedStatement transInsert = MySql.getMySql().getStatement("Insert into IntronTranscript (Intron,Transcript) values (?,?)");
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = reader.readLine();
        int count = 0;
        while (line != null){
            String[] tokens = line.split(" ");
            if (tokens[1].contains("#")){
                tokens[1] = tokens[1].substring(0, tokens[1].indexOf('#'));
                int iduhf=0;
            }
            Intron intron = new Intron(tokens[0]);
            intronInsert.setString(1, intron.id);
            intronInsert.setString(2, intron.chrom);
            intronInsert.setInt(3, intron.start);
            intronInsert.setInt(4, intron.end);
            intronInsert.setString(5, intron.strand);
            intronInsert.execute();
            System.out.printf("%s\n", intron.id);

            String[] wbTranscripts = tokens[1].substring(3).split(",");
            intron.locateWormBaseTranscripts(wbTranscripts);
            for (String transcript : intron.transcripts){
                transInsert.setString(1, intron.id);
                transInsert.setString(2, transcript);
                transInsert.execute();
                ++count;
                System.out.printf("\t%s\n", transcript);
            }
            
            line = reader.readLine();
        }
        System.out.println(count);
    }
    public static void main(String[] args) throws Exception {
        Intron.loadFromDCPMFile(
        new File("/net/waterston/vol2/home/gevirl/Unification/introns.all_june_freeze_stages.with_transcript_names"));
    }
    String id;
    String strand;
    String chrom;
    int start;
    int end;
    TreeSet<String> transcripts = new TreeSet<String>();
}
