/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.meme;

import htsjdk.samtools.util.Interval;
import java.util.Set;
import java.util.TreeMap;

/**
 *
 * @author gevirl
 */
public class FimoRecord {

    TreeMap<String, String> motifMap = new TreeMap<>();

    public FimoRecord(String[] heads, String line) {
        this(heads, line.split("\t"));
    }

    public FimoRecord(String[] heads, String[] tokens) {
        for (int i = 0; i < heads.length; ++i) {
            motifMap.put(heads[i], tokens[i]);
        }
    }

    public String getValue(String key) {
        return motifMap.get(key);
    }

    public Set<String> getMotifIDs(){
        return motifMap.keySet();
    }
    public Interval asInterval() {
        int start = Integer.valueOf(getValue("start"));
        int stop = Integer.valueOf(getValue("stop"));
        String seq = getValue("sequence_name");
        String name = getValue("motif_alt_id");
        return new Interval(seq, start, stop, true, name);
    }
}
