/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.kdeexpression;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.rhwlab.beans.EmbryoCell;

/**
 *
 * @author gevirl
 */
public class KDEExpressionFile {
    public KDEExpressionFile(File file) throws Exception {
        readExpressFile(file);
    }
    private void readExpressFile(File expressFile)throws Exception {
        map = new HashMap<String,String[]>();
        BufferedReader reader = new BufferedReader(new FileReader(expressFile));
        String line = reader.readLine();
        while(line != null) {
            String[] tokens = line.split(":");
            int index = tokens[0].indexOf('(');
            String cellName = tokens[0].substring(0, index);
            String[] valuesStr = tokens[1].split(",");
            map.put(cellName, valuesStr);
            // find tha maximum value
            for (String val : valuesStr){
                double v = Double.valueOf(val);
                if (v > maxExpression) maxExpression = v;
                if (v < minExpression) minExpression = v;
            }
            line = reader.readLine();
        }
        reader.close();
    } 
    // add a series to the JFreeChart collection for each cell and its ancestors
    public int buildCollection(XYSeriesCollection collection,EmbryoCell cell){
        int end = -1;
        EmbryoCell parent = cell.getParentCell();
        if (parent != null){
            end = buildCollection(collection,parent);
        }    
        
        XYSeries xySeries = new XYSeries(cell.getName());
        // add this cells expression
        String[] values = map.get(cell.getName());
        int s = 0;
        int e = values.length;
       
        for (int i=s ; i<e ;++i){
            xySeries.add(end+1+i,new Double(values[i]));
        }
        collection.addSeries(xySeries);
        return end + values.length;
        
    } 
    // build the time series from data in the expression map
    public int buildTimeSeries(ArrayList<Double> result,EmbryoCell cell){
        int end = -1;
        EmbryoCell parent = cell.getParentCell();
        if (parent != null){
            end = buildTimeSeries(result,parent);
        }    
        
        // add this cells expression
        String[] values = map.get(cell.getName());
        int s = 0;
        int e = values.length;
       
        for (int i=s ; i<e ;++i){
            result.add(end+1+i,new Double(values[i]));
        }
        return end + values.length;        
    }
    public HashMap<String,String[]> getMap(){
        return this.map;
    }
    public double getMin(){
        return this.minExpression;
    }
    public double getmax(){
        return this.maxExpression;
    }
    double maxExpression = Double.MIN_VALUE;
    double minExpression = Double.MAX_VALUE;   
    HashMap<String,String[]> map;
}
