/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.imaging.multitree;
import java.util.List;
import java.util.ArrayList;
import java.awt.image.BufferedImage;
import org.rhwlab.beans.SeriesEmbryo;
import org.rhwlab.beans.EmbryoCell;
import org.rhwlab.beans.SulstonEmbryo;
import org.rhwlab.db.MySql;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import org.rhwlab.imaging.binarytree.*;
/**
 *
 * @author gevirl
 */
public class MultiEmbryoTreeImage {
    public MultiEmbryoTreeImage(MySql db){
        this.db = db;
        this.images = new ArrayList<MultiTreeImage>();
        this.embryoList = new ArrayList<SeriesEmbryo>();
    }
    public MultiEmbryoTreeImage(MySql db,List<SeriesEmbryo> embryos) throws Exception {
        this (db);
        embryoList.addAll(embryos);
        init();
    }
    public void addEmbryo(SeriesEmbryo embryo){
        embryoList.add(embryo);
    }
    public void init() throws Exception {
        // find the maximum depth of all the embryos included in the tree
        float maxSulston = Integer.MIN_VALUE;
        for (SeriesEmbryo embryo : embryoList){
            int depth = embryo.getEndTime();
            float sulstonTime = embryo.sulstonTime(depth);
            if (sulstonTime > maxSulston) maxSulston = sulstonTime;
        }
        int maxdepth = (int)(maxSulston);
        
        // construct the sulston embryo to use as a basis for drawing the tree
        SulstonEmbryo sulston = new SulstonEmbryo(db,new Integer(maxdepth));
        
        // sulstonize all the embryos 
        for (SeriesEmbryo embryo : embryoList){
            sulston.sulstonize(embryo);
        }
        
        // make a tree for each root in the sulston embryo
        EmbryoCell[] roots = sulston.getEmbryo().getRoots();
        
        int h = 0;
        for (EmbryoCell root : roots){
            Dimension d = new Dimension(5*maxdepth,20*embryoList.size()*root.getLeafCount());
            h = h + d.height;
            float timeScale = (d.width-200)/root.getEndTime();
            MultiTreeImage image = new MultiTreeImage(root,embryoList,h,timeScale,400);
            images.add(image);
        }
        
        dim = new Dimension(5*maxdepth,h);
    }
    public BufferedImage getImage()throws Exception {
        if (dim==null) init();
        BufferedImage bigimage = new BufferedImage(dim.width,dim.height,BufferedImage.TYPE_INT_ARGB);
        Graphics2D g2 = bigimage.createGraphics(); 
        
        int pos = 0;
        for (MultiTreeImage image : images){
            BufferedImage bufImage = image.getImage();
            g2.drawImage(bufImage,new AffineTransformOp(new AffineTransform(),
                AffineTransformOp.TYPE_NEAREST_NEIGHBOR),0,pos);   
            pos = pos + bufImage.getHeight();
        }
        return bigimage;
    }
    public Dimension getDimension(){
        return dim;
    }
    public String getLabelAt(int x,int y){
        for (MultiTreeImage im : images){
            String lab = im.getLabelAt(x, y);
            if (lab != null) return lab;
        }
        return null;
    }
    MySql db;
    ArrayList<SeriesEmbryo> embryoList;
    ArrayList<MultiTreeImage> images;
    Dimension dim=null;
}
