/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.imaging.binarytree;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import org.rhwlab.beans.EmbryoCell;
import org.rhwlab.beans.SeriesEmbryo;

/**
 *
 * @author gevirl
 */
public class VerticalMultiSeriesMultiLineageTreeImage {
    public VerticalMultiSeriesMultiLineageTreeImage(SeriesEmbryo[] embryos,String[] lineageRoots,int[] scaleMax)throws Exception {
        this.embryos = embryos;
        images = new VerticalMultiSeriesLineageTreeImage[lineageRoots.length];
        nLeaves = new int[lineageRoots.length];
        
        // make the color scale for each embryo and find the longest embryo
        DefaultColorScale[] scales = new DefaultColorScale[embryos.length];
        for (int e=0 ; e<embryos.length ; ++e){
            if (scaleMax != null){
                scales[e] = new DefaultColorScale(0,scaleMax[e]);
            } else {
                scales[e] = new DefaultColorScale(0,(int)(0.5*embryos[e].maxExpression()));
            }
        }
        
        // find the maximum number of leaves for each lineage and maximum time depth
        int maxDepth = 0;
        int h = 0;
        int w = 0;
        for (int l=0 ; l<lineageRoots.length ; ++l){
            nLeaves[l] = 0;
            // find the embryo with the most leaves for the lineage

            for (SeriesEmbryo embryo : embryos){
                EmbryoCell cell = embryo.getCell(lineageRoots[l]);
                int n =cell.getLeafCount();
                if (n > nLeaves[l]) nLeaves[l]=n;
                int depth = Utils.getMaxDepth(cell);
                if (depth > maxDepth) maxDepth = depth;
            }
//            float timeScale = (width)/maxDepth;

            images[l] = new VerticalMultiSeriesLineageTreeImage(embryos,scales,lineageRoots[l],leafHeight*nLeaves[l],timeScale,labelWidth);
            Dimension d = images[l].getSize();
            h = h + d.height;
            w = d.width;
        }
        dim = new Dimension(w,h);
    }
    public BufferedImage getImage(){

        int h = totalLeaves();
        BufferedImage bigimage = new BufferedImage(dim.width,dim.height,BufferedImage.TYPE_INT_ARGB);
        Graphics2D g2 = bigimage.createGraphics(); 
        
        int pos = 0;
        for (int i=0 ; i<images.length ; ++i){
            BufferedImage lineageImage = images[i].getImage();
            g2.drawImage(lineageImage,new AffineTransformOp(new AffineTransform(),
                AffineTransformOp.TYPE_NEAREST_NEIGHBOR),0,pos);   
            pos = pos + lineageImage.getHeight();
        }
        return bigimage;         
    }
    public Dimension getSize(){
        
        return dim;
    }
    public int totalLeaves(){
        int h = 0;
        for (int i=0 ; i<nLeaves.length ; ++i){
            h = h + nLeaves[i];
        }
        return h;        
    }
    static int labelWidth = 400;
    static float timeScale = (float)1.5;
    static int leafHeight = 20;
    SeriesEmbryo[] embryos;
    int[] nLeaves;
    Dimension dim;
    VerticalMultiSeriesLineageTreeImage[] images;
}
