/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.imaging.binarytree;

import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.rhwlab.beans.SeriesEmbryo;
import org.rhwlab.beans.SulstonEmbryo;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */
public class VerticalMultiSeriesMultiLineageFrame extends JFrame {
    public VerticalMultiSeriesMultiLineageFrame(SeriesEmbryo[] embryos,String[] lineages)throws Exception {
        JScrollPane scroll = new JScrollPane();
        VerticalMultiSeriesMultiLineagePanel panel = new VerticalMultiSeriesMultiLineagePanel(embryos,lineages);
        scroll.setViewportView(panel);
        this.add(scroll);   
    }
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {  
                try {
                    MySql db = MySql.getMySql();
                    
                    String[] lineages = new String[12];
                    lineages[0] = "P3";
                    lineages[1] = "C";
                    lineages[2] = "E";
                    lineages[3] = "MS";
                    lineages[4] = "ABpra";
                    lineages[5] = "ABprp";
                    lineages[6] = "ABpla";
                    lineages[7] = "ABplp";
                    lineages[8] = "ABara";
                    lineages[9] = "ABarp";
                    lineages[10] = "ABala";
                    lineages[11] = "ABalp";
                    SulstonEmbryo sulston = new SulstonEmbryo();
                    SeriesEmbryo[] embryos = new SeriesEmbryo[2];
                    embryos[0] = new SeriesEmbryo("20120925_aha-1_2_L1","zblot");
                    sulston.sulstonize(embryos[0]);
                    embryos[1] = new SeriesEmbryo("20120925_aha-1_2_L2","zblot");
                    sulston.sulstonize(embryos[1]);
                    VerticalMultiSeriesMultiLineageFrame frame = new VerticalMultiSeriesMultiLineageFrame(embryos,lineages); 
                    frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
                    frame.setPreferredSize(new Dimension(500,500));
                    frame.pack();
                    frame.setVisible(true);
                } catch (Exception exc){
                    exc.printStackTrace();
                }
            }
        }); 
    }     
}
